/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class SettingsUpdater
implements SettingsChangeNotifier.ChangeListener {
    private final ISettingsChangedHandler fHandler;
    private final Control fControl;
    private final DisposeListener fDisposeListener;
    private String[] fInterestingGroupIds;

    public SettingsUpdater(ISettingsChangedHandler handler, Control control) {
        this(handler, control, null);
    }

    public SettingsUpdater(ISettingsChangedHandler handler, Control control, String[] groupIds) {
        this.fHandler = handler;
        this.fControl = control;
        this.setInterestingGroups(groupIds);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.fDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SettingsUpdater.this.dispose();
            }
        };
        this.fControl.addDisposeListener(this.fDisposeListener);
    }

    public void setInterestingGroups(String[] groupIds) {
        this.fInterestingGroupIds = groupIds;
    }

    public void settingsChanged(Set<String> groupIds) {
        if (this.fInterestingGroupIds == null) {
            this.runUpdate(groupIds);
            return;
        }
        String[] stringArray = this.fInterestingGroupIds;
        int n = this.fInterestingGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (groupIds.contains(id)) {
                this.runUpdate(groupIds);
                return;
            }
            ++n2;
        }
    }

    private void runUpdate(final Set<String> groupIds) {
        final HashMap options = new HashMap();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (UIAccess.isOkToUse(SettingsUpdater.this.fControl)) {
                    SettingsUpdater.this.fHandler.handleSettingsChanged(groupIds, options);
                }
            }
        });
    }

    public void dispose() {
        this.fControl.removeDisposeListener(this.fDisposeListener);
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
    }
}

