/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExtStatusDialog
extends StatusDialog
implements IRunnableContext {
    protected static final int WITH_RUNNABLE_CONTEXT = 1;
    protected static final int WITH_DATABINDING_CONTEXT = 2;
    protected static final int SHOW_INITIAL_STATUS = 4;
    private final int fOptions;
    private Composite fProgressComposite;
    private ProgressMonitorPart fProgressMonitorPart;
    private Button fProgressMonitorCancelButton;
    private int fActiveRunningOperations;
    private Control fProgressLastFocusControl;
    private ControlEnableState fProgressLastContentEnableState;
    private Control[] fProgressLastButtonControls;
    private boolean[] fProgressLastButtonEnableStates;
    protected DataBindingSupport fDataBinding;

    public ExtStatusDialog(Shell parent) {
        this(parent, 0);
    }

    public ExtStatusDialog(Shell parent, int options) {
        super(parent);
        this.fOptions = options;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point savedSize = super.getInitialSize();
        Point minSize = this.getShell().computeSize(-1, -1);
        return new Point(Math.max(savedSize.x, minSize.x), Math.max(savedSize.y, minSize.y));
    }

    public void create() {
        super.create();
        Button button = this.getButton(0);
        Shell shell = this.getShell();
        if (button != null && shell != null && !shell.isDisposed()) {
            shell.setDefaultButton(button);
        }
        if ((this.fOptions & 2) != 0) {
            this.initBindings();
        }
    }

    protected void initBindings() {
        DataBindingSupport databinding = new DataBindingSupport(this.getDialogArea());
        this.addBindings(databinding);
        databinding.installStatusListener(new StatusUpdater());
        if ((this.fOptions & 4) == 0) {
            IStatus status = this.getStatus();
            this.updateStatus(Status.OK_STATUS);
            this.updateButtonsEnableState(status);
        }
        this.fDataBinding = databinding;
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected DataBindingSupport getDataBinding() {
        return this.fDataBinding;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 0;
        if ((this.fOptions & 1) != 0) {
            Composite monitorComposite = this.createMonitorComposite(composite);
            Control[] children = composite.getChildren();
            layout.numColumns = 3;
            ++((GridData)children[0].getLayoutData()).horizontalSpan;
            monitorComposite.moveBelow(children[1]);
            monitorComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        return composite;
    }

    private Composite createMonitorComposite(Composite parent) {
        this.fProgressComposite = new Composite(parent, 0);
        GridLayout layout = LayoutUtils.newCompositeGrid(2);
        layout.marginLeft = LayoutUtils.defaultHMargin();
        this.fProgressComposite.setLayout((Layout)layout);
        this.fProgressMonitorPart = new ProgressMonitorPart(this.fProgressComposite, null);
        this.fProgressMonitorPart.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fProgressMonitorCancelButton = this.createButton(this.fProgressComposite, 1000, IDialogConstants.CANCEL_LABEL, true);
        Dialog.applyDialogFont((Control)this.fProgressComposite);
        this.fProgressComposite.setVisible(false);
        return this.fProgressComposite;
    }

    /*
     * Unable to fully structure code
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block13: {
            if ((this.fOptions & 1) == 0) {
                throw new UnsupportedOperationException();
            }
            if (this.getShell() != null && this.getShell().isVisible()) {
                if (this.fActiveRunningOperations == 0) {
                    this.fProgressLastFocusControl = this.getShell().getDisplay().getFocusControl();
                    if (this.fProgressLastFocusControl != null && this.fProgressLastFocusControl.getShell() != this.getShell()) {
                        this.fProgressLastFocusControl = null;
                    }
                    this.fProgressLastContentEnableState = ControlEnableState.disable((Control)this.getDialogArea());
                    buttons = new ArrayList<Control>();
                    var8_6 = this.getButton(0).getParent().getChildren();
                    var7_7 = var8_6.length;
                    var6_8 = 0;
                    while (var6_8 < var7_7) {
                        child = var8_6[var6_8];
                        if (child instanceof Button) {
                            buttons.add(child);
                        }
                        ++var6_8;
                    }
                    this.fProgressLastButtonControls = buttons.toArray(new Control[buttons.size()]);
                    this.fProgressLastButtonEnableStates = new boolean[this.fProgressLastButtonControls.length];
                    i = 0;
                    while (i < this.fProgressLastButtonControls.length) {
                        this.fProgressLastButtonEnableStates[i] = this.fProgressLastButtonControls[i].getEnabled();
                        this.fProgressLastButtonControls[i].setEnabled(false);
                        ++i;
                    }
                    this.fProgressMonitorCancelButton.setEnabled(cancelable);
                    this.fProgressMonitorPart.attachToCancelComponent((Control)this.fProgressMonitorCancelButton);
                    this.fProgressComposite.setVisible(true);
                    this.fProgressMonitorCancelButton.setFocus();
                }
                ++this.fActiveRunningOperations;
                try {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
                }
                finally {
                    --this.fActiveRunningOperations;
                    if (this.fActiveRunningOperations != 0 || this.getShell() == null) break block13;
                    this.fProgressComposite.setVisible(false);
                    this.fProgressLastContentEnableState.restore();
                    i = 0;
                    ** while (i < this.fProgressLastButtonControls.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.fProgressLastButtonControls[i].setEnabled(this.fProgressLastButtonEnableStates[i]);
                    ++i;
                    continue;
                }
lbl47:
                // 1 sources

                this.fProgressMonitorPart.removeFromCancelComponent((Control)this.fProgressMonitorCancelButton);
                if (this.fProgressLastFocusControl != null) {
                    this.fProgressLastFocusControl.setFocus();
                }
            } else {
                PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
            }
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.fActiveRunningOperations > 0) {
            Button okButton = this.getButton(0);
            int i = 0;
            while (i < this.fProgressLastButtonControls.length) {
                if (this.fProgressLastButtonControls[i] == okButton) {
                    this.fProgressLastButtonEnableStates[i] = okButton.isEnabled();
                }
                ++i;
            }
        }
    }

    public class StatusUpdater
    implements StatusChangeListener {
        public void statusChanged(IStatus status) {
            ExtStatusDialog.this.updateStatus(status);
        }
    }
}

