/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.ltk.ui.AdvancedExtensionsInternal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistCategory;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ContentAssistComputerRegistry
implements SettingsChangeNotifier.ManageListener,
Disposable {
    public static String DEFAULT_DISABLED = "assist.default.disabled_categories.ids";
    public static String CIRCLING_ORDERED = "assist.circling.ordered_categories.ids:enabled";
    private final String contentTypeId;
    private final String qualifier;
    private final Preference.StringSetPref prefDisabledCategoryIds;
    private final Preference.StringArrayPref prefOrderedCategoryIds;
    private @Nullable ImList<ComputerDescriptor> computers;
    private @Nullable ImList<ContentAssistCategory> categories;

    public static final Bundle getBundle(IConfigurationElement element) {
        String namespace = element.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return (Bundle)ObjectUtils.nonNullAssert((Object)bundle);
    }

    protected static final Map<String, ContentAssistCategory> createCategoryByIdMap(List<ContentAssistCategory> categories) {
        HashMap<String, ContentAssistCategory> map = new HashMap<String, ContentAssistCategory>();
        for (ContentAssistCategory category : categories) {
            map.put(category.getId(), category);
        }
        return map;
    }

    public ContentAssistComputerRegistry(String contentTypeId, String prefQualifier) {
        this.contentTypeId = contentTypeId;
        this.qualifier = prefQualifier;
        this.prefDisabledCategoryIds = new Preference.StringSetPref(prefQualifier, DEFAULT_DISABLED);
        this.prefOrderedCategoryIds = new Preference.StringArrayPref(prefQualifier, CIRCLING_ORDERED);
        PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)this);
    }

    public void dispose() {
        SettingsChangeNotifier notifier = PreferencesUtil.getSettingsChangeNotifier();
        if (notifier != null) {
            notifier.removeManageListener((SettingsChangeNotifier.ManageListener)this);
        }
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    String getSettingsGroupId() {
        return this.qualifier;
    }

    Preference.StringSetPref getPrefDefaultDisabledCategoryIds() {
        return this.prefDisabledCategoryIds;
    }

    Preference.StringArrayPref getPrefCirclingOrderedCategoryIds() {
        return this.prefOrderedCategoryIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeSettingsChangeNotification(Set<String> groupIds) {
        if (this.qualifier != null && groupIds.contains(this.qualifier)) {
            ContentAssistComputerRegistry contentAssistComputerRegistry = this;
            synchronized (contentAssistComputerRegistry) {
                if (this.categories != null) {
                    this.categories = ImCollections.toList(this.applyPreferences(EPreferences.getInstancePrefs(), (List<ContentAssistCategory>)this.categories));
                }
            }
        }
    }

    public void afterSettingsChangeNotification(Set<String> groupIds) {
    }

    private void loadExtensions() {
        IConfigurationElement[] elements;
        ArrayList<IConfigurationElement> categoryConfigs = new ArrayList<IConfigurationElement>();
        ArrayList<ComputerDescriptor> allComputers = new ArrayList<ComputerDescriptor>();
        HashMap<String, ArrayList<ComputerDescriptor>> computersByCategoryId = new HashMap<String, ArrayList<ComputerDescriptor>>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.statet.ltk.AdvancedContentAssist");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("category")) {
                categoryConfigs.add(element);
            } else if (element.getName().equals("computer")) {
                String id = null;
                try {
                    String contentTypeId = AdvancedExtensionsInternal.getCheckedString(element, "contentTypeId");
                    if (this.contentTypeId.equals(contentTypeId)) {
                        IConfigurationElement[] partitionConfigs;
                        id = AdvancedExtensionsInternal.getCheckedString(element, "id").intern();
                        String categoryId = AdvancedExtensionsInternal.getCheckedString(element, "categoryId");
                        HashSet<String> partitions = new HashSet<String>();
                        IConfigurationElement[] iConfigurationElementArray2 = partitionConfigs = element.getChildren("partition");
                        int n3 = partitionConfigs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement partitionConfig = iConfigurationElementArray2[n4];
                            partitions.add(AdvancedExtensionsInternal.getCheckedString(partitionConfig, "partitionType").intern());
                            ++n4;
                        }
                        this.checkPartitions(partitions);
                        ComputerDescriptor computer = new ComputerDescriptor(id, partitions, element);
                        allComputers.add(computer);
                        ArrayList<ComputerDescriptor> list = (ArrayList<ComputerDescriptor>)computersByCategoryId.get(categoryId);
                        if (list == null) {
                            list = new ArrayList<ComputerDescriptor>(4);
                            computersByCategoryId.put(categoryId, list);
                        }
                        list.add(computer);
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, NLS.bind((String)"Loading Completion Proposal Computer ''{0}'' failed (contributed by= ''{1}'')", (Object)(id != null ? id : ""), (Object)element.getDeclaringExtension().getContributor().getName()), (Throwable)e));
                }
            }
            ++n2;
        }
        ArrayList<ContentAssistCategory> categories = new ArrayList<ContentAssistCategory>(8);
        for (IConfigurationElement catConfig : categoryConfigs) {
            String id = null;
            try {
                id = AdvancedExtensionsInternal.getCheckedString(catConfig, "id");
                List descriptors = (List)computersByCategoryId.get(id);
                if (descriptors == null) continue;
                ImageDescriptor icon = AdvancedExtensionsInternal.getImageDescriptor(catConfig, "icon");
                String name = AdvancedExtensionsInternal.getCheckedString(catConfig, "name");
                ContentAssistCategory cat = new ContentAssistCategory(id, name, icon, descriptors);
                categories.add(cat);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, NLS.bind((String)"Loading Completion Proposal Category ''{0}'' failed (contributed by= ''{1}'')", (Object)(id != null ? id : ""), (Object)catConfig.getDeclaringExtension().getContributor().getName()), (Throwable)e));
            }
        }
        this.computers = ImCollections.toList(allComputers);
        this.categories = ImCollections.toList(this.applyPreferences(EPreferences.getInstancePrefs(), categories));
    }

    List<ContentAssistCategory> applyPreferences(PreferenceAccess prefAccess, List<ContentAssistCategory> categories) {
        Set disabledIds = (Set)prefAccess.getPreferenceValue((Preference)this.getPrefDefaultDisabledCategoryIds());
        for (ContentAssistCategory category : categories) {
            boolean enabled;
            category.isIncludedInDefault = enabled = disabledIds == null || !disabledIds.contains(category.getId());
        }
        Map<String, ContentAssistCategory> map = ContentAssistComputerRegistry.createCategoryByIdMap(categories);
        String[] orderPref = (String[])prefAccess.getPreferenceValue((Preference)this.getPrefCirclingOrderedCategoryIds());
        ArrayList<ContentAssistCategory> ordered = new ArrayList<ContentAssistCategory>(categories.size());
        String[] stringArray = orderPref;
        int n = orderPref.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            String id;
            String value = stringArray[n2];
            int idx = value.lastIndexOf(58);
            if (idx > 0) {
                id = value.substring(0, idx);
                enabled = Boolean.parseBoolean(value.substring(idx + 1, value.length()));
            } else {
                id = value;
                enabled = false;
            }
            ContentAssistCategory category = map.remove(id);
            if (category != null) {
                ordered.add(category);
                category.isEnabledAsSeparate = enabled;
            }
            ++n2;
        }
        for (ContentAssistCategory category : map.values()) {
            ordered.add(category);
            category.isEnabledAsSeparate = false;
        }
        return ordered;
    }

    Map<Preference<?>, Object> createPreferences(List<ContentAssistCategory> orderedCategories) {
        HashSet<String> disabledIds = new HashSet<String>();
        String[] orderedPref = new String[orderedCategories.size()];
        int i = 0;
        while (i < orderedCategories.size()) {
            ContentAssistCategory category = orderedCategories.get(i);
            if (!category.isIncludedInDefault) {
                disabledIds.add(category.getId());
            }
            orderedPref[i] = category.getId() + (category.isEnabledAsSeparate ? ":true" : ":false");
            ++i;
        }
        HashMap prefMap = new HashMap();
        prefMap.put((Preference<?>)this.getPrefDefaultDisabledCategoryIds(), disabledIds);
        prefMap.put((Preference<?>)this.getPrefCirclingOrderedCategoryIds(), orderedPref);
        return prefMap;
    }

    protected void checkPartitions(Set<String> partitions) {
    }

    public synchronized ImList<ContentAssistCategory> getCategories() {
        ImList<ContentAssistCategory> categories = this.categories;
        if (categories == null) {
            this.loadExtensions();
            categories = this.categories;
        }
        return categories;
    }

    public List<ContentAssistCategory> getCopyOfCategories() {
        ImList<ContentAssistCategory> categories = this.getCategories();
        ArrayList<ContentAssistCategory> copies = new ArrayList<ContentAssistCategory>(categories.size());
        for (ContentAssistCategory category : categories) {
            copies.add(new ContentAssistCategory(category));
        }
        return copies;
    }

    public ImList<ContentAssistCategory> getCategory(String categoryId) {
        ImList<ContentAssistCategory> categories = this.getCategories();
        for (ContentAssistCategory category : categories) {
            if (!category.getId().equals(categoryId)) continue;
            ContentAssistCategory copy = new ContentAssistCategory(category);
            copy.isIncludedInDefault = true;
            return ImCollections.newList((Object)copy);
        }
        return ImCollections.emptyList();
    }

    private synchronized ImList<ComputerDescriptor> getComputers() {
        ImList<ComputerDescriptor> computers = this.computers;
        if (computers == null) {
            this.loadExtensions();
            computers = this.computers;
        }
        return computers;
    }

    public @Nullable ContentAssistComputer getComputer(String id) {
        ImList<ComputerDescriptor> computers = this.getComputers();
        for (ComputerDescriptor descr : computers) {
            if (!descr.getId().equals(id)) continue;
            return descr.getComputer();
        }
        return null;
    }

    class CategoryPreferences {
        public final List<ContentAssistCategory> allCategories;
        public final List<ContentAssistCategory> defaultEnabledCategories;
        public final List<ContentAssistCategory> circlingOrderedCategories;
        public final List<ContentAssistCategory> circlingOrderedEnabledCategories;

        public CategoryPreferences(List<ContentAssistCategory> categories) {
            this.allCategories = categories;
            this.defaultEnabledCategories = new ArrayList<ContentAssistCategory>(categories.size());
            this.circlingOrderedCategories = new ArrayList<ContentAssistCategory>(categories.size());
            this.circlingOrderedEnabledCategories = new ArrayList<ContentAssistCategory>(categories.size());
        }
    }

    final class ComputerDescriptor {
        private final String id;
        private final Set<String> partitions;
        private final IConfigurationElement configurationElement;
        private @Nullable ContentAssistComputer computer;
        private boolean triedLoadingComputer = false;

        ComputerDescriptor(String id, Set<String> partitions, IConfigurationElement configurationElement) {
            this.id = id;
            this.partitions = partitions;
            this.configurationElement = configurationElement;
        }

        public String getId() {
            return this.id;
        }

        public Set<String> getPartitions() {
            return this.partitions;
        }

        public @Nullable ContentAssistComputer getComputer() {
            if (this.computer == null && !this.triedLoadingComputer && this.configurationElement != null) {
                this.triedLoadingComputer = true;
                try {
                    this.computer = (ContentAssistComputer)this.configurationElement.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)"Loading Content Assist Computer ''{0}'' failed (contributed by= '' {1}'').", (Object)this.id, (Object)this.configurationElement.getDeclaringExtension().getContributor().getName()), (Throwable)e));
                }
            }
            return this.computer;
        }
    }
}

