/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.menus.UIElement;

public class SubmitFileViaCommandHandler
extends AbstractHandler
implements IElementUpdater {
    private final boolean fGotoConsole;

    public SubmitFileViaCommandHandler() {
        this(false);
    }

    public SubmitFileViaCommandHandler(boolean gotoConsole) {
        this.fGotoConsole = gotoConsole;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String fileCommandId = event.getParameter("fileCommandId");
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        String contentTypeId = LTKWorkbenchUIUtil.getContentTypeId((IWorkbenchPart)activePart);
        try {
            IStructuredSelection sel;
            ISelection selection;
            IWorkbenchPart encodingAdaptable = null;
            SourceUnit su = null;
            IFile file = null;
            URI uri = null;
            if (activePart instanceof IEditorPart) {
                IEditorPart editor;
                IEditorInput input;
                encodingAdaptable = activePart;
                SourceEditor sourceEditor = (SourceEditor)activePart.getAdapter(SourceEditor.class);
                if (sourceEditor != null && (su = sourceEditor.getSourceUnit()) != null) {
                    encodingAdaptable = sourceEditor;
                }
                if (su == null) {
                    su = (SourceUnit)activePart.getAdapter(SourceUnit.class);
                }
                if (su == null && (file = ResourceUtil.getFile((IEditorInput)(input = (editor = (IEditorPart)activePart).getEditorInput()))) == null && input instanceof IURIEditorInput) {
                    uri = ((IURIEditorInput)input).getURI();
                }
            }
            if (su == null && file == null && uri == null && (selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext())) instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
                Object object = sel.getFirstElement();
                if (object instanceof SourceUnit) {
                    su = (SourceUnit)object;
                } else if (object instanceof SourceElement) {
                    su = ((SourceElement)object).getSourceUnit();
                } else if (object instanceof IAdaptable) {
                    su = (SourceUnit)((IAdaptable)object).getAdapter(SourceUnit.class);
                }
                if (su == null) {
                    if (object instanceof IFile) {
                        file = (IFile)object;
                    } else if (object instanceof IAdaptable) {
                        file = (IFile)((IAdaptable)object).getAdapter(IFile.class);
                    }
                }
            }
            if (su != null && file == null) {
                if (su.getResource() instanceof IFile) {
                    file = (IFile)su.getResource();
                } else {
                    FileUtil fileUtil = FileUtil.getFileUtil((Object)su.getResource());
                    if (fileUtil != null) {
                        uri = fileUtil.getURI();
                    }
                }
            } else if (su == null && file != null) {
                su = LtkModels.getSourceUnitManager().getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)file, null, true, null);
            }
            if (file != null && uri == null) {
                uri = file.getLocationURI();
            }
            if (uri != null) {
                if (su != null) {
                    while (su != null && su.getWorkingContext() != Ltk.PERSISTENCE_CONTEXT) {
                        su = su.getUnderlyingUnit();
                    }
                }
                String command = null;
                if (file != null) {
                    if (contentTypeId == null) {
                        contentTypeId = LaunchShortcutUtil.getContentTypeId(file);
                    }
                    command = fileCommandId != null ? RCodeLaunching.getFileCommand(fileCommandId) : RCodeLaunching.getPreferredFileCommand(contentTypeId);
                } else {
                    if (contentTypeId == null) {
                        contentTypeId = LaunchShortcutUtil.getContentTypeId(uri);
                    }
                    String string = command = fileCommandId != null ? RCodeLaunching.getFileCommand(fileCommandId) : RCodeLaunching.getPreferredFileCommand(contentTypeId);
                }
                if (command != null) {
                    RCodeLaunching.runFileUsingCommand(command, uri, su, this.getEncoding((IAdaptable)encodingAdaptable, file), this.fGotoConsole);
                    return null;
                }
            }
        }
        catch (Exception e) {
            LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RScriptLaunch_error_message, event);
            return null;
        }
        LaunchShortcutUtil.handleUnsupportedExecution(event);
        return null;
    }

    private String getEncoding(IAdaptable adaptable, IFile file) throws CoreException {
        IEncodingSupport encodingSupport;
        if (adaptable != null && (encodingSupport = (IEncodingSupport)adaptable.getAdapter(IEncodingSupport.class)) != null) {
            return encodingSupport.getEncoding();
        }
        if (file != null) {
            return file.getCharset(true);
        }
        return null;
    }
}

