/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.pkgmanager.RLibrarySelectionComposite;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.statushandlers.StatusManager;

public class InstallPkgFileWizard
extends Wizard {
    private final Tool rTool;
    private final IRPkgManager.Ext pkgManager;
    private Page page;

    public InstallPkgFileWizard(Tool rTool, IRPkgManager.Ext manager) {
        this.rTool = rTool;
        this.pkgManager = manager;
        this.setWindowTitle("R Package Manager");
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"pkgmanager/InstallPkgFileWizard"));
    }

    public void addPages() {
        this.page = new Page();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveSettings();
        final IFileStore store = this.page.getFile();
        final RLibLocation location = this.page.getTargetLocation();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IRPkgData pkgData = InstallPkgFileWizard.this.pkgManager.addToCache(store, monitor);
                        RPkgAction.Install action = new RPkgAction.Install(pkgData, location, null);
                        InstallPkgFileWizard.this.pkgManager.perform(InstallPkgFileWizard.this.rTool, Collections.singletonList(action));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", "An error occurred when preparing the R package installation from file.", e.getCause()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    class Page
    extends WizardPage {
        private static final String FILE_HISTORY = "RPkgFile.history";
        private final IObservableValue<String> fileValue;
        private final IObservableValue<RPkgType> typeValue;
        private final IObservableValue<RLibLocation> targetValue;
        private ResourceInputComposite fileControl;
        private Label typeControl;
        private RLibrarySelectionComposite targetControl;

        public Page() {
            super("InstallPkgFilePage");
            this.setTitle("Install R Package from File");
            this.setDescription("Select the package file and target location.");
            Realm realm = Realm.getDefault();
            this.fileValue = new WritableValue(realm, (Object)"", String.class);
            this.typeValue = new WritableValue(realm, null, RPkgType.class);
            this.targetValue = new WritableValue(realm, null, RLibLocation.class);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
            this.fileControl = new ResourceInputComposite(composite, 5, 9, "Package &file");
            this.fileControl.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fileControl.setHistory(this.getDialogSettings().getArray(FILE_HISTORY));
            this.typeControl = new Label(composite, 0);
            this.typeControl.setText("Type: ");
            this.typeControl.setLayoutData((Object)new GridData(4, 4, true, false));
            RuntimeRLibPaths rLibPaths = InstallPkgFileWizard.this.pkgManager.getRLibPaths();
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText("Target Library:");
            group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
            this.targetControl = new RLibrarySelectionComposite((Composite)group);
            this.targetControl.setLayoutData(this.targetControl.createGD());
            this.targetControl.getValidator().setWritable(true);
            this.targetControl.setInput(rLibPaths);
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
            DataBindingSupport databinding = new DataBindingSupport((Control)composite);
            this.addBindings(databinding);
            this.validateType();
            this.targetValue.setValue((Object)RPkgUtils.getDefaultInstallLocation((RuntimeRLibPaths)rLibPaths));
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)databinding.getContext());
        }

        protected void addBindings(DataBindingSupport databinding) {
            this.fileControl.getValidator().setOnNotLocal(0);
            this.fileControl.getValidator().setFileStoreValidator(store -> {
                if (store.getName().indexOf(95) < 0 || RPkgUtils.getPkgType((String)store.getName(), (RPlatform)InstallPkgFileWizard.this.pkgManager.getRPlatform()) == null) {
                    return ValidationStatus.error((String)"File name must follow the pattern '<package_name>_<version>.<ext>'.");
                }
                this.validateType();
                return ValidationStatus.ok();
            });
            databinding.getContext().bindValue(this.fileControl.getObservable(), this.fileValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.fileControl.getValidator()), null);
            this.fileControl.getTextControl().addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    Page.this.validateType();
                }
            });
            databinding.getContext().bindValue((IObservableValue)ViewerProperties.singleSelection(Object.class).observe((Viewer)this.targetControl.getSelectionViewer()), this.targetValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.targetControl.getValidator()), null);
        }

        void validateType() {
            RPkgType type = null;
            IFileStore store = this.fileControl.getResourceAsFileStore();
            if (store != null) {
                type = RPkgUtils.getPkgType((String)store.getName(), (RPlatform)InstallPkgFileWizard.this.pkgManager.getRPlatform());
            }
            Object text = "Type: ";
            if (type != null) {
                text = (String)text + type.getLabel() + " (" + RPkgUtils.getPkgTypeInstallKey((RPlatform)InstallPkgFileWizard.this.pkgManager.getRPlatform(), (RPkgType)type) + ")";
            }
            this.typeControl.setText((String)text);
            this.typeValue.setValue((Object)type);
        }

        public IFileStore getFile() {
            return this.fileControl.getResourceAsFileStore();
        }

        public RPkgType getType() {
            return (RPkgType)this.typeValue.getValue();
        }

        public RLibLocation getTargetLocation() {
            return (RLibLocation)this.targetValue.getValue();
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)FILE_HISTORY, (String)((String)this.fileValue.getValue()));
        }
    }
}

