/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ComparatorViewerComparator;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.pkgmanager.EditRepoDialog;
import org.eclipse.statet.internal.r.ui.pkgmanager.RRepoLabelProvider;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

class RRepoConfigurationBlock
extends ManagedConfigurationBlock
implements ButtonGroup.IActions<RRepo> {
    private static final int R_SIZE = 3;
    private static final int REPO = 0;
    private static final int CRAN = 1;
    private static final int BIOC = 2;
    private static final ImList<Preference<List<RRepo>>> PREFS = ImCollections.newList((Object[])new Preference[]{IRPkgManager.CUSTOM_REPO_PREF, IRPkgManager.CUSTOM_CRAN_MIRROR_PREF, IRPkgManager.CUSTOM_BIOC_MIRROR_PREF});
    private static final Comparator<RRepo> COMPARATOR = new Comparator<RRepo>(){

        @Override
        public int compare(RRepo o1, RRepo o2) {
            int diff = o1.getName().compareTo(o2.getName());
            if (diff != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    };
    private final ViewerUtils.TableComposite[] tables = new ViewerUtils.TableComposite[3];
    private final ButtonGroup<RRepo>[] buttonsGroups = new ButtonGroup[3];
    private final IObservableList<RRepo>[] lists = new IObservableList[3];
    private final Set<String> ids = new HashSet<String>();

    public RRepoConfigurationBlock(StatusChangeListener statusListener) {
        super(null, "R Custom Repositories", statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Preference, Object> prefs = new HashMap<Preference, Object>();
        prefs.put(IRPkgManager.CUSTOM_REPO_PREF, null);
        prefs.put(IRPkgManager.CUSTOM_CRAN_MIRROR_PREF, null);
        prefs.put(IRPkgManager.CUSTOM_BIOC_MIRROR_PREF, null);
        this.setupPreferenceManager(prefs);
        this.addLinkHeader(pageComposite, "Additional custom repositories for R packages. There is no need to add the default R repositories or mirrors.");
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.createTable(composite, 0, "R&epositories");
        this.createTable(composite, 1, "CR&AN Mirrors");
        this.createTable(composite, 2, "&Bioconductor Mirrors");
        this.initBindings();
        this.updateControls();
    }

    protected void addBindings(DataBindingSupport db) {
        int i = 0;
        while (i < 3) {
            this.lists[i] = new WritableList(db.getRealm(), new ArrayList(), RRepo.class);
            this.tables[i].viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tables[i].viewer.setInput(this.lists[i]);
            this.buttonsGroups[i].connectTo((StructuredViewer)this.tables[i].viewer, this.lists[i], null);
            ++i;
        }
    }

    private void createTable(Composite parent, int r, String s) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setText(s + ":");
        ViewerUtils.TableComposite table = new ViewerUtils.TableComposite(parent, 67586);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = LayoutUtils.hintHeight((Table)table.table, (int)(r == 0 ? 9 : 3));
        table.setLayoutData((Object)gd);
        TableViewerColumn column = table.addColumn("Repository", 16384, (ColumnLayoutData)new ColumnWeightData(100));
        column.setLabelProvider((CellLabelProvider)new RRepoLabelProvider());
        table.viewer.setComparator((ViewerComparator)new ComparatorViewerComparator(COMPARATOR));
        this.tables[r] = table;
        ViewerUtils.scheduleStandardSelection((TableViewer)table.viewer);
        ButtonGroup buttons = new ButtonGroup(parent, (ButtonGroup.IActions)this, false);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        buttons.addAddButton(null);
        buttons.addEditButton(null);
        buttons.addDeleteButton(null);
        this.buttonsGroups[r] = buttons;
    }

    public RRepo edit(int command, RRepo item, Object parent) {
        EditRepoDialog dialog;
        RRepo repo = new RRepo((command & 3) != 0 ? this.newId() : item.getId());
        if (item != null) {
            repo.set(item);
        }
        if ((dialog = new EditRepoDialog(this.getShell(), repo, item == null)).open() == 0) {
            if (repo.getName().isEmpty()) {
                repo.setName(RRepo.hintName((RRepo)repo));
            }
            return repo;
        }
        return null;
    }

    private String newId() {
        String id;
        while (this.ids.contains(id = "custom-" + System.currentTimeMillis())) {
        }
        return id;
    }

    public void updateState(IStructuredSelection selection) {
    }

    protected void updateControls() {
        super.updateControls();
        int i = 0;
        while (i < 3) {
            this.lists[i].clear();
            List repos = (List)this.getPreferenceValue((Preference)PREFS.get(i));
            for (RRepo repo : repos) {
                this.ids.add(repo.getId());
            }
            this.lists[i].addAll((Collection)repos);
            this.buttonsGroups[i].refresh();
            ++i;
        }
    }

    protected void updatePreferences() {
        int i = 0;
        while (i < 3) {
            Object[] array = (RRepo[])this.lists[i].toArray((Object[])new RRepo[this.lists[i].size()]);
            Arrays.sort(array, COMPARATOR);
            this.setPrefValue((Preference)PREFS.get(i), ImCollections.newList((Object[])array));
            ++i;
        }
        super.updatePreferences();
    }
}

