/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.function.Consumer;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.IRVariable;

@NonNullByDefault
public class RElementVariableCompactStore {
    private final @Nullable RElementVariable[] array;

    public RElementVariableCompactStore(int length) {
        this.array = new RElementVariable[length];
    }

    public void set(int idx, RElementVariable value) {
        this.array[idx] = value;
    }

    public @Nullable RElementVariable get(int idx) {
        return this.array[idx];
    }

    public @Nullable RElementVariable clear(int idx) {
        RElementVariable value = this.array[idx];
        this.array[idx] = null;
        return value;
    }

    public void forEachSet(Consumer<RElementVariable> action) {
        int idx = 0;
        while (idx < this.array.length) {
            RElementVariable value = this.array[idx];
            if (value != null) {
                action.accept(value);
            }
            ++idx;
        }
    }

    public void toArray(@Nullable IRVariable[] to, int idx) {
        System.arraycopy(this.array, 0, to, idx, this.array.length);
    }
}

