/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.yaml.core.ast.NContainer;
import org.eclipse.statet.yaml.core.ast.NodeType;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlAstVisitor;

@NonNullByDefault
public abstract class Collection
extends NContainer {
    private Collection(YamlAstNode parent, int offset, int endOffset) {
        super(parent, offset, endOffset);
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    public abstract int getOpenIndicatorOffset();

    public abstract int getCloseIndicatorOffset();

    /* synthetic */ Collection(YamlAstNode yamlAstNode, int n, int n2, Collection collection) {
        this(yamlAstNode, n, n2);
    }

    static abstract class BlockCollection
    extends Collection {
        BlockCollection(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset, null);
        }

        @Override
        public int getOpenIndicatorOffset() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getCloseIndicatorOffset() {
            return Integer.MIN_VALUE;
        }
    }

    static final class BlockMap
    extends BlockCollection {
        BlockMap(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        @Override
        public char getOperator() {
            return ':';
        }
    }

    static final class BlockSeq
    extends BlockCollection {
        BlockSeq(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.SEQUENCE;
        }

        @Override
        public char getOperator() {
            return '-';
        }
    }

    static abstract class FlowCollection
    extends Collection {
        int closeIndicatorOffset = Integer.MIN_VALUE;

        FlowCollection(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset, null);
        }

        @Override
        public int getOpenIndicatorOffset() {
            return this.startOffset;
        }

        @Override
        public int getCloseIndicatorOffset() {
            return this.closeIndicatorOffset;
        }
    }

    static final class FlowMap
    extends FlowCollection {
        FlowMap(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        @Override
        public char getOperator() {
            return '{';
        }
    }

    static final class FlowSeq
    extends FlowCollection {
        FlowSeq(YamlAstNode parent, int offset, int endOffset) {
            super(parent, offset, endOffset);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.SEQUENCE;
        }

        @Override
        public char getOperator() {
            return '[';
        }
    }
}

