/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model.build;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.yaml.core.model.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.StatusDetail;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.ast.Collection;
import org.eclipse.statet.yaml.core.ast.Dummy;
import org.eclipse.statet.yaml.core.ast.Scalar;
import org.eclipse.statet.yaml.core.ast.Tuple;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.model.YamlCompositeSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;

@NonNullByDefault
public class YamlProblemReporter
extends YamlAstVisitor {
    private static final int BUFFER_SIZE = 64;
    private static final int START_TEXT_LIMIT = 25;
    private static final int MASK = 0xFFFFFF;
    private final boolean reportSubsequent = false;
    private SourceUnit sourceUnit;
    private SourceContent sourceContent;
    private ProblemRequestor problemRequestor;
    private final StringBuilder sBuilder = new StringBuilder();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(64);

    public void run(YamlSourceUnitModelInfo model, SourceContent content, ProblemRequestor requestor, int level, IProgressMonitor monitor) {
        try {
            try {
                YamlSourceElement root = model.getSourceElement();
                this.sourceUnit = root.getSourceUnit();
                this.sourceContent = content;
                this.problemRequestor = requestor;
                if (root instanceof YamlCompositeSourceElement) {
                    for (SourceStructElement chunk : ((YamlCompositeSourceElement)root).getCompositeElements()) {
                        this.check((AstNode)chunk.getAdapter(AstNode.class));
                    }
                } else {
                    this.check((AstNode)root.getAdapter(AstNode.class));
                }
                if (!this.problemBuffer.isEmpty()) {
                    this.problemRequestor.acceptProblems("Yaml", this.problemBuffer);
                }
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.sourceUnit = null;
                this.sourceContent = null;
                this.problemRequestor = null;
                this.problemBuffer.clear();
            }
        }
        finally {
            this.sourceUnit = null;
            this.sourceContent = null;
            this.problemRequestor = null;
            this.problemBuffer.clear();
        }
    }

    private void check(@Nullable AstNode node) throws InvocationTargetException {
        if (node instanceof YamlAstNode) {
            ((YamlAstNode)node).acceptInYaml(this);
        }
    }

    private boolean requiredCheck(int code) {
        return code != 0 && (code & 0x100000) == 0;
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        } else if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        this.problemBuffer.add((Problem)new BasicProblem("Yaml", severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 64) {
            this.problemRequestor.acceptProblems("Yaml", this.problemBuffer);
            this.problemBuffer.clear();
        }
    }

    protected final StringBuilder getStringBuilder() {
        this.sBuilder.setLength(0);
        return this.sBuilder;
    }

    protected String getStartText(YamlAstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            if (text.length() > 25) {
                StringBuilder sb = this.getStringBuilder();
                sb.append(text, 0, 25);
                sb.append('\u2026');
                return sb.toString();
            }
            return text;
        }
        if (node.getLength() - offset > 25) {
            StringBuilder sb = this.getStringBuilder();
            sb.append(this.sourceContent.getText(), node.getStartOffset() + offset, node.getStartOffset() + offset + 25);
            sb.append('\u2026');
            return sb.toString();
        }
        return this.sourceContent.getText().substring(node.getStartOffset() + offset, node.getEndOffset() + offset);
    }

    protected void handleCommonCodes(YamlAstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0xFFFF0) {
            case 69968: {
                this.addProblem(2, code, this.messageBuilder.bind(Messages.Syntax_GenTokenUnknown_message, (Object)this.getStartText(node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
            case 69984: {
                this.addProblem(2, code, this.messageBuilder.bind(Messages.Syntax_GenTokenUnexpected_message, (Object)this.getStartText(node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
        }
    }

    @Override
    public void visit(Collection node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFFF) {
                    case 70931: {
                        this.addProblem(2, code, Messages.Syntax_FlowSeqNotClosed_message, node.getStartOffset(), node.getStartOffset() + 1);
                        break;
                    }
                    case 70932: {
                        this.addProblem(2, code, Messages.Syntax_FlowMapNotClosed_message, node.getStartOffset(), node.getStartOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInYamlChildren(this);
    }

    @Override
    public void visit(Tuple node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFFF) {
                    case 70425: {
                        this.addProblem(2, code, Messages.Syntax_FlowSeqNotClosed_message, node.getKeyNode().getEndOffset() - 1, node.getKeyNode().getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInYamlChildren(this);
    }

    @Override
    public void visit(Scalar node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 69904: {
                        this.addProblem(2, code, this.messageBuilder.bind(Messages.Syntax_QuotedScalarNotClosed_message, (Object)this.getStartText(node, 1), (Object)String.valueOf(node.getOperator())), node.getEndOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 69920: {
                        StatusDetail detail = StatusDetail.getStatusDetail((AstNode)node);
                        if (detail != null) {
                            this.addProblem(2, code, this.messageBuilder.bind(Messages.Syntax_QuotedScalarEscapeSequenceInvalid_messsage, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                            break;
                        }
                        this.addProblem(2, code, this.messageBuilder.bind(Messages.Syntax_GenEscapeSequenceInvalid_messsage, (Object)this.getStartText(node, 0)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

