/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.statet.internal.r.debug.ui.ProjectSelectionDialog;
import org.eclipse.statet.r.debug.core.sourcelookup.RProjectSourceContainer;
import org.eclipse.swt.widgets.Shell;

public class RProjectSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        List<IProject> projects = this.getPossibleAdditions(director);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, projects);
        if (dialog.open() == 0) {
            Set selectedProjects = dialog.getCheckedElements();
            ArrayList<RProjectSourceContainer> containers = new ArrayList<RProjectSourceContainer>();
            for (IProject project : projects) {
                if (!selectedProjects.contains(project)) continue;
                RProjectSourceContainer container = new RProjectSourceContainer(project, false);
                container.init(director);
                containers.add(container);
            }
            return containers.toArray(new ISourceContainer[containers.size()]);
        }
        return new ISourceContainer[0];
    }

    protected List<IProject> getPossibleAdditions(ISourceLookupDirector director) {
        ISourceContainer[] containers;
        List<IProject> projects = this.getRResourceProjects();
        ISourceContainer[] iSourceContainerArray = containers = director.getSourceContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            if (container.getType().getId().equals("org.eclipse.statet.r.debugSourceContainers.RProjectType")) {
                projects.remove(((RProjectSourceContainer)container).getProject());
            }
            ++n2;
        }
        return projects;
    }

    protected List<IProject> getRResourceProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> collected = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.hasNature("org.eclipse.statet.r.resourceProjects.R")) {
                    collected.add(project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return collected;
    }
}

