/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class FencedCodeBlock
extends SourceBlockType<CodeBlockNode> {
    private static final Pattern START_PATTERN = Pattern.compile("(?:`{3,}[^`]*|~{3,}.*)", 32);
    private static final Pattern OPEN_PATTERN = Pattern.compile("(`{3,}|~{3,})[ \t]*([^ \t]+)?.*", 32);
    private static final int OPEN_SYMBOL_GROUP = 1;
    private static final int OPEN_INFO_TEXT_GROUP = 2;
    private static final Pattern CLOSE_BACKTICK_PATTERN = Pattern.compile("(`{3,})[ \t]*", 32);
    private static final Pattern CLOSE_TILDE_PATTERN = Pattern.compile("(~{3,})[ \t]*", 32);
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher openMatcher;
    private @Nullable Matcher closeBacktickMatcher;
    private @Nullable Matcher closeTildeMatcher;

    private Matcher getOpenMatcher() {
        Matcher matcher = this.openMatcher;
        if (matcher == null) {
            this.openMatcher = matcher = OPEN_PATTERN.matcher("");
        }
        return matcher;
    }

    private Matcher getCloseMatcher(Line line, Matcher openMatcher) {
        switch (line.getText().charAt(openMatcher.start(1))) {
            case '`': {
                Matcher matcher = this.closeBacktickMatcher;
                if (matcher == null) {
                    this.closeBacktickMatcher = matcher = CLOSE_BACKTICK_PATTERN.matcher("");
                }
                return matcher;
            }
            case '~': {
                Matcher matcher = this.closeTildeMatcher;
                if (matcher == null) {
                    this.closeTildeMatcher = matcher = CLOSE_TILDE_PATTERN.matcher("");
                }
                return matcher;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.startMatcher).matches();
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        Line line;
        CodeBlockNode node = new CodeBlockNode(this, builder);
        LineSequence lineSequence = builder.getLineSequence();
        Line startLine = lineSequence.getCurrentLine();
        lineSequence.advance();
        Matcher openMatcher = startLine.setup(this.getOpenMatcher(), true, false);
        FencedCodeBlock.assertMatches(openMatcher);
        int minCount = openMatcher.end(1) - openMatcher.regionStart();
        node.infoText = this.getInfoText(openMatcher);
        Matcher closeMatcher = this.getCloseMatcher(startLine, openMatcher);
        while ((line = lineSequence.getCurrentLine()) != null) {
            lineSequence.advance();
            if (line.isBlank() || line.getIndent() >= 4 || !line.setupIndent(closeMatcher).matches() || closeMatcher.end(1) - closeMatcher.regionStart() < minCount) continue;
            node.isClosed = true;
            break;
        }
    }

    @Override
    public void initializeContext(ProcessingContext context, CodeBlockNode node) {
    }

    @Override
    public void emit(ProcessingContext context, CodeBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = node.getLines();
        Line startLine = (Line)lines.get(0);
        Matcher openMatcher = startLine.setup(this.getOpenMatcher(), true, false);
        FencedCodeBlock.assertMatches(openMatcher);
        SourceElementAttributes attributes = new SourceElementAttributes(!node.isClosed ? 256 : 0);
        if (node.infoText != null) {
            String language = this.getLanguage(node.infoText);
            attributes.setCssClass("language-" + context.getHelper().replaceEscaping(language));
        }
        locator.setBlockBegin(node);
        builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)attributes);
        int startIndent = startLine.getIndent();
        for (Line line : lines.subList(1, node.isClosed ? lines.size() - 1 : lines.size())) {
            Line codeSegment = startIndent > 0 && line.getIndent() > 0 ? line.segmentByIndent(Math.min(startIndent, line.getIndent())) : line;
            locator.setLine(codeSegment);
            builder.characters(codeSegment.getText());
            builder.characters("\n");
        }
        locator.setBlockEnd(node);
        builder.endBlock();
    }

    private @Nullable String getInfoText(Matcher openMatcher) {
        String infoText = openMatcher.group(2);
        if (infoText != null && !infoText.isEmpty()) {
            return CommonRegex.trimWhitespace(infoText);
        }
        return null;
    }

    private String getLanguage(String infoString) {
        int index = 0;
        while (index < infoString.length()) {
            if (CommonRegex.isWhitespace(infoString.charAt(index))) {
                return infoString.substring(0, index);
            }
            ++index;
        }
        return infoString;
    }

    static final class CodeBlockNode
    extends SourceBlockNode<FencedCodeBlock> {
        private @Nullable String infoText;
        private boolean isClosed;

        private CodeBlockNode(FencedCodeBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

