/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HtmlTag;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class HtmlTagSpan
extends SourceSpan {
    private static final Pattern PATTERN = Pattern.compile("(<(?:!--(?:-->|-?[^>-](?:-?[^-])*-->)|\\?.*?\\?>|!\\p{Upper}+\\s[^>]*>|!\\[CDATA\\[.*?\\]\\]>|\\p{Alpha}[\\p{Alnum}-]*(?:\\s+[\\p{Alpha}_:][\\p{Alnum}_.:-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\\s\"'=><`]+))?)*\\s*/?>|/\\p{Alpha}[\\p{Alnum}-]*\\s*>)).*", 32);
    private @Nullable Matcher matcher;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '<' && (matcher = cursor.setup(this.getMatcher())).matches()) {
            int startOffset = cursor.getOffset();
            int endOffset = cursor.getMatcherOffset(matcher.end(1));
            return new HtmlTag(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, matcher.group(1));
        }
        return null;
    }

    private Matcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = PATTERN.matcher("");
        }
        return this.matcher;
    }
}

