/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;

public class CorrectOffsetDocumentBuilder
extends DocumentBuilder {
    private static final byte S_endBlock = 1;
    private static final byte S_endSpan = 2;
    private static final byte S_endHeading = 3;
    private final DocumentBuilder builder;
    private byte state;

    public CorrectOffsetDocumentBuilder(DocumentBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        this.builder = builder;
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
        this.builder.setLocator(locator);
    }

    private void check() {
        switch (this.state) {
            case 1: {
                this.builder.endBlock();
                break;
            }
            case 2: {
                this.builder.endSpan();
                break;
            }
            case 3: {
                this.builder.endHeading();
                break;
            }
            default: {
                return;
            }
        }
        this.state = 0;
    }

    public void reset() {
        this.state = 0;
    }

    public void close() {
        this.check();
        this.reset();
    }

    public void beginDocument() {
        this.reset();
        this.builder.beginDocument();
    }

    public void endDocument() {
        this.check();
        this.builder.endDocument();
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.check();
        this.builder.beginBlock(type, attributes);
    }

    public void endBlock() {
        this.check();
        this.state = 1;
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.check();
        this.builder.beginSpan(type, attributes);
    }

    public void endSpan() {
        this.check();
        this.state = (byte)2;
    }

    public void beginHeading(int level, Attributes attributes) {
        this.check();
        this.builder.beginHeading(level, attributes);
    }

    public void endHeading() {
        this.check();
        this.state = (byte)3;
    }

    public void characters(String text) {
        this.check();
        this.builder.characters(text);
    }

    public void entityReference(String entity) {
        this.check();
        this.builder.entityReference(entity);
    }

    public void image(Attributes attributes, String url) {
        this.check();
        this.builder.image(attributes, url);
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.check();
        this.builder.link(attributes, hrefOrHashName, text);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.check();
        this.builder.imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    public void acronym(String text, String definition) {
        this.check();
        this.builder.acronym(text, definition);
    }

    public void lineBreak() {
        this.check();
        this.builder.lineBreak();
    }

    public void charactersUnescaped(String literal) {
        this.check();
        this.builder.charactersUnescaped(literal);
    }
}

