/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.statet.ecommons.resources.core.BuildUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.refactoring.ECommonsRefactoring;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.ui.EditorUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.statushandlers.StatusManager;

public class RefactoringSaveHelper {
    public static final int SAVE_NOTHING = 0;
    public static final int SAVE_ALL = 1;
    public static final int SAVE_REFACTORING = 2;
    public static final int EXCLUDE_ACTIVE_EDITOR = 16;
    public static final int OPTIONAL = 256;
    public static final int ASK_ALWAYS = 512;
    private boolean filesSaved;
    private final int saveMode;

    public RefactoringSaveHelper(int saveMode) {
        this.saveMode = saveMode;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        List<IEditorPart> dirtyEditors;
        switch (this.saveMode & 0xF) {
            case 1: {
                dirtyEditors = EditorUtils.getDirtyEditors(true);
                break;
            }
            case 2: {
                dirtyEditors = EditorUtils.getDirtyEditors(true);
                break;
            }
            case 0: {
                return true;
            }
            default: {
                throw new IllegalStateException(Integer.toString(this.saveMode));
            }
        }
        if ((this.saveMode & 0x10) != 0) {
            IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
            dirtyEditors.remove(page.getActiveEditor());
        }
        if (dirtyEditors.isEmpty()) {
            return true;
        }
        if (!this.askSaveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            boolean autoBuild = BuildUtils.setAutoBuilding((boolean)false);
            try {
                if ((this.saveMode & 0xF) == 1 || ECommonsRefactoring.getSaveAllEditors()) {
                    if (!PlatformUI.getWorkbench().saveAllEditors(false)) {
                        return false;
                    }
                } else {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                            try {
                                int count = dirtyEditors.size();
                                m.setWorkRemaining(count);
                                int i = 0;
                                while (i < count) {
                                    IEditorPart editor = (IEditorPart)dirtyEditors.get(i);
                                    editor.doSave((IProgressMonitor)m.newChild(1));
                                    if (m.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                    ++i;
                                }
                            }
                            finally {
                                m.done();
                            }
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)UIAccess.getActiveWorkbenchWindow((boolean)true), runnable, null);
                    }
                    catch (InterruptedException e) {
                        BuildUtils.setAutoBuilding((boolean)autoBuild);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, Messages.RefactoringStarter_UnexpectedException, e.getCause()));
                        BuildUtils.setAutoBuilding((boolean)autoBuild);
                        return false;
                    }
                }
                this.filesSaved = true;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                BuildUtils.setAutoBuilding((boolean)autoBuild);
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, Messages.RefactoringStarter_UnexpectedException, (Throwable)e));
            return false;
        }
    }

    public void triggerBuild() {
        if (this.filesSaved) {
            new GlobalBuildAction(UIAccess.getActiveWorkbenchWindow((boolean)true), 10).run();
        }
    }

    public void triggerAutoBuild() {
        if (this.filesSaved && ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            new GlobalBuildAction(UIAccess.getActiveWorkbenchWindow((boolean)true), 10).run();
        }
    }

    public boolean didSaveFiles() {
        return this.filesSaved;
    }

    private boolean askSaveAllDirtyEditors(Shell shell, List<IEditorPart> dirtyEditors) {
        boolean canSaveAutomatically;
        boolean bl = canSaveAutomatically = (this.saveMode & 0x200) == 0;
        if (canSaveAutomatically && ECommonsRefactoring.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){
            {
                super($anonymous0);
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                if (canSaveAutomatically) {
                    final Button check = new Button(result, 32);
                    check.setText(Messages.RefactoringStarter_ConfirmSave_Always_message);
                    check.setSelection(ECommonsRefactoring.getSaveAllEditors());
                    check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ECommonsRefactoring.setSaveAllEditors(check.getSelection());
                        }
                    });
                    2.applyDialogFont((Control)result);
                }
                return result;
            }
        };
        dialog.setTitle(Messages.RefactoringStarter_ConfirmSave_title);
        dialog.setMessage(Messages.RefactoringStarter_ConfirmSave_message);
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        });
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(dirtyEditors);
        return dialog.open() == 0;
    }
}

