/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;

@NonNullByDefault
public abstract class AbstractEditorTemplatesPage
extends AbstractTemplatesPage {
    private final EnhTemplateStore templateStore;
    private final EnhTemplateStore.WorkingCopy templateStoreWorkingCopy;
    private @Nullable Runnable templateStoreListener;
    private final ITextEditor editorPart;
    private final ISourceEditor sourceEditor;
    private ISourceEditor previewEditor;
    private final TemplateVariableProcessor previewTemplateProcessor;
    private final TemplateVariableProcessor editTemplateProcessor;
    private @Nullable SourceEditorViewerConfigurator currentPreviewConfigurator;
    private @Nullable TextViewerJFaceUpdater currentPreviewUpdater;

    protected AbstractEditorTemplatesPage(EnhTemplateStore templateStore, ITextEditor editorPart, ISourceEditor sourceEditor) {
        super(editorPart, (ISourceViewer)sourceEditor.getViewer());
        this.templateStore = templateStore;
        this.templateStoreWorkingCopy = this.templateStore.getWorkingCopy();
        this.editorPart = editorPart;
        this.sourceEditor = sourceEditor;
        this.previewTemplateProcessor = new TemplateVariableProcessor();
        this.editTemplateProcessor = new TemplateVariableProcessor();
    }

    protected ISourceEditor getSourceEditor() {
        return this.sourceEditor;
    }

    protected AssistInvocationContext createContext(ISourceEditor editor, TextRegion region) throws BadPartitioningException, BadLocationException {
        String contentType = TextUtils.getContentType((IDocument)editor.getViewer().getDocument(), (DocContentSections)editor.getDocumentContentInfo(), (int)region.getStartOffset(), (boolean)true);
        return new AssistInvocationContext(editor, region, contentType, 0, null);
    }

    public TemplateStore getTemplateStore() {
        return this.templateStoreWorkingCopy;
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return this.templateStore.getContextTypeRegistry();
    }

    protected abstract @Nullable TemplateCompletionComputer getComputer(AssistInvocationContext var1, Template var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        ISourceEditor sourceEditor = this.getSourceEditor();
        if (sourceEditor == null) {
            return false;
        }
        try {
            String[] contextIds = this.getContextTypeIds(document, offset);
            int i = 0;
            while (true) {
                if (i >= contextIds.length) {
                    return false;
                }
                if (contextIds[i].equals(template.getContextTypeId())) {
                    BasicTextRegion region = new BasicTextRegion(offset, offset + length);
                    AssistInvocationContext context = this.createContext(sourceEditor, (TextRegion)region);
                    TemplateCompletionComputer computer = this.getComputer(context, template);
                    if (computer == null) {
                        return false;
                    }
                    SourceEditorTemplateContext templateContext = computer.createTemplateContext(context, (TextRegion)region, 0, true);
                    if (templateContext == null) return false;
                    if (!templateContext.canEvaluate(template)) return false;
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void insertTemplate(Template template, IDocument document) {
        ISourceEditor sourceEditor = this.getSourceEditor();
        if (sourceEditor == null || !sourceEditor.isEditable(true)) {
            return;
        }
        try {
            AssistInvocationContext context;
            AssistInvocationContext region = context = this.createContext(sourceEditor, sourceEditor.getSelectedRegion());
            TemplateCompletionComputer computer = this.getComputer(context, template);
            if (computer == null) {
                return;
            }
            SourceEditorTemplateContext templateContext = computer.createTemplateContext(context, region, 0, true);
            if (templateContext == null) {
                return;
            }
            TemplateProposal proposal = new TemplateProposal(new TemplateProposal.TemplateProposalParameters<AssistInvocationContext>(context, (TextRegion)region, templateContext, template));
            this.editorPart.getSite().getPage().activate((IWorkbenchPart)this.editorPart);
            proposal.apply((ITextViewer)sourceEditor.getViewer(), '\u0000', 0, region.getStartOffset());
        }
        catch (Exception e) {
            LTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An error occurred when applying editor template.", (Throwable)e));
        }
    }

    public void createControl(Composite ancestor) {
        Runnable listener = this.templateStoreListener;
        if (listener == null) {
            listener = new Runnable(){

                @Override
                public void run() {
                    EnhTemplateStore.WorkingCopy templateStore = AbstractEditorTemplatesPage.this.templateStoreWorkingCopy;
                    if (templateStore != null) {
                        templateStore.load();
                    }
                }
            };
            this.templateStore.addListener(listener);
            this.templateStoreListener = listener;
        }
        listener.run();
        super.createControl(ancestor);
    }

    public void dispose() {
        Runnable templateStoreListener = this.templateStoreListener;
        if (templateStoreListener != null) {
            this.templateStore.removeListener(templateStoreListener);
            this.templateStoreListener = null;
        }
        this.disposePreviewUpdater();
        super.dispose();
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        new TextViewerEditorColorUpdater(viewer, EditorsUI.getPreferenceStore());
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        this.previewEditor = new ViewerSourceEditorAdapter(viewer, null);
        new SettingsUpdater(new ISettingsChangedHandler(){

            public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
                SourceEditorViewerConfigurator configurator = AbstractEditorTemplatesPage.this.currentPreviewConfigurator;
                if (configurator != null) {
                    configurator.handleSettingsChanged(groupIds, options);
                }
            }
        }, viewer.getControl());
        return viewer;
    }

    protected void updatePatternViewer(@Nullable Template template) {
        SourceViewer patternViewer = this.getPatternViewer();
        if (patternViewer == null || !UIAccess.isOkToUse((Control)patternViewer.getControl())) {
            return;
        }
        if (template != null) {
            SourceEditorViewerConfigurator configurator = this.getTemplatePreviewConfig(template, this.previewTemplateProcessor);
            TemplateContextType type = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
            this.previewTemplateProcessor.setContextType(type);
            SourceEditorViewerConfigurator currentConfigurator = this.currentPreviewConfigurator;
            if (configurator != currentConfigurator) {
                this.disposePreviewUpdater();
                if (currentConfigurator != null) {
                    this.currentPreviewConfigurator = null;
                    currentConfigurator.unconfigureTarget();
                }
                configurator.setTarget(this.previewEditor);
                this.currentPreviewConfigurator = configurator;
                this.currentPreviewUpdater = new TextViewerJFaceUpdater((ISourceViewer)patternViewer, configurator.getSourceViewerConfiguration().getPreferences());
                Document document = new Document();
                configurator.getDocumentSetupParticipant().setup((IDocument)document);
                this.configureDocument((AbstractDocument)document, type, configurator);
                document.set(template.getPattern());
                patternViewer.setDocument((IDocument)document);
            } else {
                AbstractDocument document = (AbstractDocument)patternViewer.getDocument();
                document.set("");
                this.configureDocument(document, type, configurator);
                document.set(template.getPattern());
            }
        } else {
            patternViewer.getDocument().set("");
        }
        patternViewer.setSelectedRange(0, 0);
    }

    private void disposePreviewUpdater() {
        TextViewerJFaceUpdater updater = this.currentPreviewUpdater;
        if (updater != null) {
            this.currentPreviewUpdater = null;
            updater.dispose();
        }
    }

    protected @Nullable Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        SourceEditorViewerConfigurator configurator = this.getTemplateEditConfig(template, this.editTemplateProcessor);
        EditTemplateDialog dialog = new EditTemplateDialog(this.getSite().getShell(), template, edit, 1, configurator, this.editTemplateProcessor, (org.eclipse.text.templates.ContextTypeRegistry)this.getContextTypeRegistry(), "org.eclipse.statet.ltk.ui/templates/config"){

            @Override
            protected void configureForContext(TemplateContextType contextType) {
                super.configureForContext(contextType);
                SourceViewer sourceViewer = this.getSourceViewer();
                AbstractDocument document = (AbstractDocument)sourceViewer.getDocument();
                AbstractEditorTemplatesPage.this.configureDocument(document, contextType, this.getSourceViewerConfigurator());
            }
        };
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected abstract SourceEditorViewerConfigurator getTemplatePreviewConfig(Template var1, TemplateVariableProcessor var2);

    protected abstract SourceEditorViewerConfigurator getTemplateEditConfig(Template var1, TemplateVariableProcessor var2);

    protected void configureDocument(AbstractDocument document, TemplateContextType contextType, SourceEditorViewerConfigurator configurator) {
    }
}

