/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;

@NonNullByDefault
public class SrcfileData
implements RJIOExternalizable {
    private final @Nullable String path;
    private final @Nullable String name;
    private final long timestamp;

    public SrcfileData(@Nullable String path, @Nullable String name, long timestamp) {
        this.path = path;
        this.name = name;
        this.timestamp = timestamp;
    }

    public SrcfileData(RJIO io) throws IOException {
        this.path = io.readString();
        this.name = io.readString();
        this.timestamp = io.readLong();
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeString(this.path);
        io.writeString(this.name);
        io.writeLong(this.timestamp);
    }

    public @Nullable String getPath() {
        return this.path;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hashCode(this.path) * 17 ^ Objects.hashCode(this.name) ^ (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SrcfileData) {
            SrcfileData other = (SrcfileData)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.name, other.name) && this.timestamp == other.timestamp;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SrcfileData");
        sb.append("\n\tpath= ").append(this.path);
        sb.append("\n\tname= ").append(this.name);
        sb.append("\n\ttimestamp= ").append(this.timestamp);
        return sb.toString();
    }
}

