/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.AbstractRDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

public class RMatrixDataAdapter
extends AbstractRDataAdapter<RArray<?>, RArray<?>> {
    @Override
    public RArray<?> validate(RObject rObject) throws UnexpectedRDataException {
        return RDataUtils.checkRArray((RObject)rObject, (int)2);
    }

    @Override
    public RArray<?> validate(RObject rObject, RArray<?> referenceObject, int flags) throws UnexpectedRDataException {
        RArray array = RDataUtils.checkRArray((RObject)rObject, (int)2);
        RDataUtils.checkColumnCountEqual((RArray)array, (int)RDataUtils.getColumnCount(referenceObject));
        if ((flags & 1) != 0) {
            RDataUtils.checkLengthEqual((RObject)array, (long)referenceObject.getLength());
        }
        if ((flags & 4) != 0) {
            RDataUtils.checkData((RStore)array.getData(), (byte)referenceObject.getData().getStoreType());
        }
        return array;
    }

    @Override
    public long getRowCount(RArray<?> rObject) {
        return rObject.getDim().getInt(0);
    }

    @Override
    public long getColumnCount(RArray<?> rObject) {
        return rObject.getDim().getInt(1);
    }

    @Override
    protected String getLoadDataFName() {
        return "rj:::sda002.getDataMatrixValues";
    }

    @Override
    protected String getSetDataFName() {
        return "rj:::.setDataMatrixValues";
    }

    @Override
    protected RArray<?> validateData(RObject rObject, RArray<?> referenceObject, LazyRStore.Fragment<RArray<?>> fragment) throws UnexpectedRDataException {
        RArray array = RDataUtils.checkRArray((RObject)rObject, (int)2);
        RDataUtils.checkColumnCountEqual((RArray)array, (int)RDataUtils.checkIntLength((long)fragment.getColumnCount()));
        RDataUtils.checkRowCountEqual((RArray)array, (int)RDataUtils.checkIntLength((long)fragment.getRowCount()));
        RDataUtils.checkData((RStore)rObject.getData(), (byte)referenceObject.getData().getStoreType());
        return array;
    }

    @Override
    protected String getLoadRowNamesFName() {
        return "rj:::sda002.getDataMatrixRowNames";
    }
}

