/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.treepartitioner;

import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class WrappedPartitionNodeScan
implements TreePartitionNodeScan {
    private final TreePartitionNodeScan parent;
    private int startOffset;
    private int endOffset;
    private TreePartitionNode beginNode;
    private boolean wasAutoBreakEnabled;

    public WrappedPartitionNodeScan(TreePartitionNodeScan parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
    }

    public void init(int startOffset, int endOffset, TreePartitionNode beginNode) {
        if (beginNode == null) {
            throw new NullPointerException("beginNode");
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.beginNode = beginNode;
        this.wasAutoBreakEnabled = this.parent.isAutoBreakEnabled();
        if (!this.wasAutoBreakEnabled) {
            this.parent.setAutoBreakEnabled(true);
        }
    }

    public void exit() {
        if (this.wasAutoBreakEnabled != this.parent.isAutoBreakEnabled()) {
            this.parent.setAutoBreakEnabled(this.wasAutoBreakEnabled);
            if (this.wasAutoBreakEnabled) {
                this.parent.checkBreak();
            }
        }
        this.beginNode = null;
    }

    @Override
    public IDocument getDocument() {
        return this.parent.getDocument();
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public TreePartitionNode getBeginNode() {
        return this.beginNode;
    }

    @Override
    public void setAutoBreakEnabled(boolean enable) {
        this.parent.setAutoBreakEnabled(enable);
    }

    @Override
    public boolean isAutoBreakEnabled() {
        return this.parent.isAutoBreakEnabled();
    }

    @Override
    public void checkBreak() throws TreePartitionNodeScan.BreakException {
        this.parent.checkBreak();
    }

    @Override
    public TreePartitionNode add(TreePartitionNodeType type, TreePartitionNode parent, int offset, int flags) {
        return this.parent.add(type, parent, offset, flags);
    }

    @Override
    public void expand(TreePartitionNode node, int endOffset, int flags, boolean close) {
        this.parent.expand(node, endOffset, flags, close);
    }

    @Override
    public void markDirtyEnd(int offset) {
        this.parent.markDirtyEnd(offset);
    }
}

