/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;

public abstract class AbstractDimPositionCommand
implements ILayerCommand {
    private ILayerDim layerDim;
    private long position;

    protected AbstractDimPositionCommand(ILayerDim layerDim, long position) {
        this.layerDim = layerDim;
        this.position = position;
    }

    protected AbstractDimPositionCommand(AbstractDimPositionCommand command) {
        this.layerDim = command.layerDim;
        this.position = command.position;
    }

    public final Orientation getOrientation() {
        return this.layerDim.getOrientation();
    }

    public final ILayerDim getDim() {
        return this.layerDim;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ILayerDim targetDim = targetLayer.getDim(this.getOrientation());
        if (this.layerDim == targetDim) {
            return true;
        }
        return this.convertToTargetLayer(this.layerDim, this.position, targetDim);
    }

    protected boolean convertToTargetLayer(ILayerDim dim, long position, ILayerDim targetDim) {
        long targetPosition = LayerUtil.convertPosition(dim, position, position, targetDim);
        if (targetPosition == Long.MIN_VALUE) {
            return false;
        }
        this.layerDim = targetDim;
        this.position = targetPosition;
        return true;
    }
}

