/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.AbstractStatus;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class MultiStatus
extends AbstractStatus {
    private byte severity;
    private ImList<Status> children;

    private static byte computeSeverity(ImList<Status> children) {
        byte severity = 0;
        for (Status child : children) {
            if (child.getSeverity() <= severity) continue;
            severity = child.getSeverity();
        }
        return severity;
    }

    public MultiStatus(String bundleId, int code, String message, @Nullable Throwable exception, ImList<Status> children) {
        super(bundleId, code, message, exception);
        this.severity = MultiStatus.computeSeverity(children);
        this.children = children;
    }

    public MultiStatus(String bundleId, int code, String message, @Nullable Throwable exception) {
        super(bundleId, code, message, exception);
        this.severity = 0;
        this.children = ImCollections.newList();
    }

    public MultiStatus(String bundleId, int code, String message) {
        super(bundleId, code, message, null);
        this.severity = 0;
        this.children = ImCollections.newList();
    }

    public MultiStatus(String bundleId, String message, @Nullable Throwable exception, ImList<Status> children) {
        super(bundleId, 0, message, exception);
        this.severity = MultiStatus.computeSeverity(children);
        this.children = children;
    }

    public MultiStatus(String bundleId, String message, @Nullable Throwable exception) {
        super(bundleId, 0, message, exception);
        this.severity = 0;
        this.children = ImCollections.newList();
    }

    public MultiStatus(String bundleId, String message) {
        super(bundleId, 0, message, null);
        this.severity = 0;
        this.children = ImCollections.newList();
    }

    @Override
    public byte getSeverity() {
        return this.severity;
    }

    @Override
    public final boolean isMultiStatus() {
        return true;
    }

    public void add(Status status) {
        this.children = ImCollections.addElement(this.children, ObjectUtils.nonNullAssert(status));
        if (status.getSeverity() > this.severity) {
            this.severity = status.getSeverity();
        }
    }

    @Override
    public ImList<Status> getChildren() {
        return this.children;
    }
}

