/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.CombinedFactory;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

public class RListVar
extends BasicCombinedRElement
implements RList,
CombinedRList,
ExternalizableRObject {
    private int length;
    private BasicCombinedRElement[] components;
    private final String className1;
    private RCharacter32Store namesAttribute;

    public RListVar(RJIO io, CombinedFactory factory, int options, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(parent, name);
        this.className1 = (options & 0x10) != 0 ? io.readString() : (this.getRObjectType() == 6 ? "data.frame" : "list");
        int l = this.length = (int)io.readVULong((byte)(options & 7));
        if ((options & 0x20) != 0) {
            this.namesAttribute = null;
            this.components = null;
        } else {
            this.namesAttribute = (RCharacter32Store)factory.readNames(io, l);
            this.components = new BasicCombinedRElement[l];
            int i = 0;
            while (i < l) {
                this.components[i] = factory.readObject(io, this, this.namesAttribute.isNA(i) || this.namesAttribute.getChar(i).isEmpty() ? RElementName.create((int)28, (String)Integer.toString(i + 1), (int)(i + 1)) : RElementName.create((int)26, (String)this.namesAttribute.getChar(i), (int)(i + 1)));
                ++i;
            }
        }
    }

    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        this.doWriteExternal(io, factory, 0);
    }

    protected final void doWriteExternal(RJIO io, RObjectFactory factory, int options) throws IOException {
        int l = this.length;
        options |= io.getVULongGrade((long)l);
        if (!this.className1.equals(this.getDefaultRClassName())) {
            options |= 0x10;
        }
        if (this.components == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), (long)l);
        if (this.components != null) {
            factory.writeNames((RStore)this.namesAttribute, io);
            int i = 0;
            while (i < l) {
                factory.writeObject((RObject)this.components[i], io);
                ++i;
            }
        }
    }

    public byte getRObjectType() {
        return 7;
    }

    protected String getDefaultRClassName() {
        return "list";
    }

    public final String getRClassName() {
        return this.className1;
    }

    protected int length() {
        return this.length;
    }

    public long getLength() {
        return this.length;
    }

    public final @Nullable RCharacterStore getNames() {
        return this.namesAttribute;
    }

    public final @Nullable String getName(int idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(idx));
        }
        return null;
    }

    public final @Nullable String getName(long idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return null;
    }

    public final @Nullable CombinedRElement get(int idx) {
        return this.components[idx];
    }

    public final @Nullable CombinedRElement get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.components[(int)idx];
    }

    public final @Nullable CombinedRElement get(String name) {
        int idx;
        if (this.namesAttribute != null && (idx = this.namesAttribute.indexOf(name, 0)) >= 0) {
            return this.components[idx];
        }
        return null;
    }

    public final @Nullable RStore<?> getData() {
        return null;
    }

    public int getElementType() {
        return 1552;
    }

    public final boolean hasModelChildren(@Nullable LtkModelElementFilter filter) {
        if (this.components == null) {
            return false;
        }
        if (filter == null) {
            return this.length > 0;
        }
        BasicCombinedRElement[] basicCombinedRElementArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final List<? extends CombinedRElement> getModelChildren(@Nullable LtkModelElementFilter filter) {
        if (this.components == null) {
            return Collections.emptyList();
        }
        if (filter == null) {
            return ImCollections.newList((Object[])this.components);
        }
        ArrayList<BasicCombinedRElement> list = new ArrayList<BasicCombinedRElement>();
        BasicCombinedRElement[] basicCombinedRElementArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                list.add(component);
            }
            ++n2;
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=list, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.length);
        if (this.components != null) {
            sb.append("\n\tdata: ");
            int i = 0;
            while (i < this.length) {
                if (i > 100) {
                    sb.append("\n... ");
                    break;
                }
                if (this.namesAttribute == null || this.namesAttribute.isNA(i)) {
                    sb.append("\n[[").append(i + 1).append("]]\n");
                } else {
                    sb.append("\n$").append(this.namesAttribute.getChar(i)).append("\n");
                }
                sb.append(this.components[i]);
                ++i;
            }
        } else {
            sb.append("\n<NODATA/>");
        }
        return sb.toString();
    }
}

