/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.ecommons.ui.components.History;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.content.ObservableSetBinding;
import org.eclipse.statet.ecommons.ui.content.SearchTextBinding;
import org.eclipse.statet.ecommons.ui.content.SetElementFilter;
import org.eclipse.statet.ecommons.ui.content.TableFilterController;
import org.eclipse.statet.ecommons.ui.content.TextElementFilter;
import org.eclipse.statet.ecommons.ui.util.AutoCheckController;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.NestedServices;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.r.ui.pkgmanager.DetailGroup;
import org.eclipse.statet.internal.r.ui.pkgmanager.IGetPkgFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.InstallPkgsWizard;
import org.eclipse.statet.internal.r.ui.pkgmanager.LaterVersionFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.LibSourceFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.NotOlderVersionFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.RPkgManagerDialog;
import org.eclipse.statet.internal.r.ui.pkgmanager.RViewLabelProvider;
import org.eclipse.statet.internal.r.ui.pkgmanager.ReadOnlyFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.RequireInstFilter;
import org.eclipse.statet.internal.r.ui.pkgmanager.Util;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfo;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.IRView;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgResolver;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.ui.REnvLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.menus.CommandContributionItemParameter;

public class PkgTab
extends Composite {
    private static final int VERSION_CHARS = 8;
    private static final int AVAIL = 0;
    private static final int INST = 1;
    private final RPkgManagerDialog dialog;
    private final IRPkgManager.Ext rPkgManager;
    private final TabItem tab;
    private IRPkgSet.Ext pkgSet;
    private String selectedPkgName;
    private int selectedPkgVersionGroup;
    private IRPkgData selectedPkgVersion;
    private final Map<String, String> selectedPkgVersions = new HashMap<String, String>();
    private SearchText filterText;
    private Button filterInstButton;
    private Button filterNotInstButton;
    private CheckboxTableViewer filterPriorityTable;
    private IObservableSet<String> filterPrioritySet;
    private StackLayout filterViewsStack;
    private Link filterViewsMessage;
    private CheckboxTableViewer filterRViewsTable;
    private IObservableSet<IRView> filterRViewsSet;
    private TableFilterController filterController;
    private ViewerUtils.TableComposite pkgTable;
    private NestedServices serviceLocator;
    private ContextHandlers handlers;
    private final History<String> pkgHistory = new History<String>(){

        protected void select(String entry) {
            PkgTab.this.showPkg(entry);
        }
    };
    private ToolBarManager toolBar;
    private ViewerUtils.TreeComposite detailTable;
    private Label detailLicense;
    private TreeViewer detailDepTable;
    private TreeViewer detailRevTable;
    private Button installButton;
    private DropDownButton updateButton;
    private Button uninstallButton;
    private Button loadButton;

    PkgTab(RPkgManagerDialog dialog, TabItem tab, Composite parent, IRPkgManager.Ext rPkgManager) {
        super(parent, 0);
        this.dialog = dialog;
        this.tab = tab;
        this.rPkgManager = rPkgManager;
        this.setLayout((Layout)LayoutUtils.newTabGrid((int)3));
        this.createContent(this);
        this.updateButtons();
        this.tab.addDisposeListener(e -> {
            if (this.handlers != null) {
                this.handlers.dispose();
                this.handlers = null;
            }
        });
    }

    private void createContent(Composite parent) {
        Composite filterCol = this.createFilter(parent);
        filterCol.setLayoutData((Object)new GridData(4, 4, false, true));
        Composite tableCol = this.createTable(parent);
        tableCol.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite detailCol = this.createDetail(parent);
        detailCol.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private Composite createFilter(Composite parent) {
        Link link;
        CheckboxTableViewer viewer;
        Button button;
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        composite.setText("Filter");
        SearchText text = new SearchText((Composite)composite, "", 2560);
        text.setMessage("Name");
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text.getTextControl(), (int)20);
        text.setLayoutData((Object)gd);
        this.filterText = text;
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        this.filterInstButton = button = new Button((Composite)composite, 32);
        button.setText("Installed");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterNotInstButton = button = new Button((Composite)composite, 32);
        button.setText("Not Installed");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label((Composite)composite, 0);
        label.setText("Priorities:");
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.filterPriorityTable = viewer = new CheckboxTableViewer(new Table((Composite)composite, 67634));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.heightHint = LayoutUtils.hintHeight((Table)viewer.getTable(), (int)IRPkgSet.Ext.DEFAULT_PRIORITIES.size(), (boolean)false);
        viewer.getControl().setLayoutData((Object)gd2);
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Task Views:");
        Composite views = new Composite((Composite)composite, 0);
        gd2 = new GridData(4, 4, true, true);
        views.setLayoutData((Object)gd2);
        this.filterViewsStack = new StackLayout();
        views.setLayout((Layout)this.filterViewsStack);
        this.filterViewsMessage = link = new Link(views, 2);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PkgTab.this.showPkg(e.text);
            }
        });
        link.setText("");
        ViewerUtils.CheckboxTableComposite table = new ViewerUtils.CheckboxTableComposite(views, 67618);
        this.filterRViewsTable = table.viewer;
        table.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)table.viewer, (int)2);
        TableViewerColumn column = table.addColumn("", 16384, (ColumnLayoutData)new ColumnWeightData(100, false));
        column.setLabelProvider((CellLabelProvider)new RViewLabelProvider());
        gd2.widthHint = LayoutUtils.hintWidth((Table)table.table, (int)20);
        this.filterViewsStack.topControl = table;
        return composite;
    }

    private Composite createTable(Composite parent) {
        ViewerUtils.TableComposite viewer;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setText("Packages:");
        label.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.toolBar = new ToolBarManager(0x800100);
        ToolBar toolBar = this.toolBar.createControl(composite);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.pkgTable = viewer = new ViewerUtils.TableComposite(composite, 268503042);
        viewer.viewer.setUseHashlookup(true);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = LayoutUtils.hintHeight((Table)viewer.table, (int)15);
        gd.widthHint = this.dialog.hintWidthInChars(40);
        viewer.setLayoutData((Object)gd);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer.viewer, (int)2);
        TableViewerColumn column = viewer.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(50));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String name = (String)cell.getElement();
                cell.setImage(RUI.getImage(PkgTab.this.pkgSet.getInstalled().contains(name) ? "org.eclipse.statet.r.ui/image/obj/r_package" : "org.eclipse.statet.r.ui/image/obj/r_package-notavail"));
                cell.setText(name);
            }

            public String getToolTipText(Object element) {
                String name = (String)element;
                IRPkgInfoAndData v = (IRPkgInfoAndData)PkgTab.this.pkgSet.getInstalled().getFirst(name);
                if (v != null) {
                    return v.getTitle();
                }
                return null;
            }
        });
        return composite;
    }

    private Composite createDetail(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.createDetailTable(composite);
        this.createDetailButtons(composite);
        this.createDetailInfo(composite);
        return composite;
    }

    private void createDetailTable(Composite parent) {
        ViewerUtils.TreeComposite composite;
        Label label = new Label(parent, 0);
        label.setText("&Versions:");
        label.setLayoutData((Object)new GridData(4, 1024, true, false));
        label = new Label(parent, 0);
        GridData gd = new GridData(4, 4, false, false);
        gd.heightHint = this.toolBar.getControl().computeSize((int)-1, (int)-1).y;
        label.setLayoutData((Object)gd);
        this.detailTable = composite = new ViewerUtils.TreeComposite(parent, 67588);
        gd = new GridData(4, 4, true, false, 1, 1);
        gd.heightHint = LayoutUtils.hintHeight((Tree)composite.tree, (int)6);
        gd.widthHint = this.dialog.hintWidthInChars(40);
        composite.setLayoutData((Object)gd);
        composite.viewer.setContentProvider((IContentProvider)new DetailGroup.ContentProvider(2){
            {
                this.groups[0] = new DetailGroup(0, "Available");
                this.groups[1] = new DetailGroup(1, "Installed");
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof String) {
                    String name = (String)newInput;
                    this.groups[0].setList(PkgTab.this.pkgSet.getAvailable().get(name));
                    this.groups[1].setList(PkgTab.this.pkgSet.getInstalled().get(name));
                } else {
                    this.groups[0].clearList();
                    this.groups[1].clearList();
                }
            }
        });
        composite.viewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof IRPkgData) {
                    return element.hashCode() + ((IRPkgData)element).getRepoId().hashCode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a == b) {
                    return true;
                }
                if (!a.equals(b)) {
                    return false;
                }
                if (a instanceof IRPkgData) {
                    return ((IRPkgData)a).getRepoId().equals(((IRPkgData)b).getRepoId());
                }
                return false;
            }
        });
        composite.viewer.setAutoExpandLevel(-1);
        TreeViewerColumn column = composite.addColumn("Repository/Library", 16384, (ColumnLayoutData)new ColumnWeightData(50, this.dialog.hintWidthInChars(20), true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof DetailGroup) {
                    cell.setText(((DetailGroup)element).getLabel());
                    return;
                }
                if (element instanceof IRPkgInfo) {
                    RLibLocation location = ((IRPkgInfo)element).getLibLocation();
                    cell.setText(REnvLabelProvider.getSafeLabel(location));
                    return;
                }
                if (element instanceof IRPkgData) {
                    RRepo repo;
                    IRPkgData pkg = (IRPkgData)element;
                    if (pkg.getRepoId() != null && (repo = RPkgUtils.getRepoById(PkgTab.this.dialog.getRepoTab().getAvailableRepos(), (String)pkg.getRepoId())) != null) {
                        cell.setText(repo.getName());
                        return;
                    }
                    cell.setText("-");
                    return;
                }
                throw new IllegalStateException();
            }
        });
        column = composite.addColumn("Version", 16384, (ColumnLayoutData)new ColumnPixelData(this.dialog.hintWidthInChars(8), true, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof IRPkgData) {
                    cell.setText(((IRPkgData)element).getVersion().toString());
                    return;
                }
                cell.setText("");
            }

            public String getToolTipText(Object element) {
                return element instanceof IRPkgData ? PkgTab.this.getDetailToolTipText((IRPkgData)element) : null;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)composite.viewer);
        composite.viewer.setInput((Object)RPkgManagerDialog.NO_INPUT);
    }

    private String getDetailToolTipText(IRPkgData pkgData) {
        StringBuilder sb = new StringBuilder(pkgData.getName());
        sb.append("\nVersion: ").append(pkgData.getVersion());
        if (pkgData instanceof IRPkgInfoAndData) {
            IRPkgInfoAndData pkgDescr = (IRPkgInfoAndData)pkgData;
            sb.append("\nBuilt: ").append(((IRPkgInfoAndData)pkgData).getBuilt());
            sb.append("\nInstalled: ").append(pkgDescr.getInstallStamp() != 0L ? DateFormat.getDateTimeInstance().format((Object)pkgDescr.getInstallStamp()) : "-");
            RRepo repo = this.rPkgManager.getRepo(pkgDescr.getRepoId());
            if (repo != null) {
                sb.append("\nFrom: ").append(repo.getName());
            }
        }
        return sb.toString();
    }

    private void createDetailButtons(Composite parent) {
        Button button;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.installButton = button = new Button(composite, 8);
        button.setText("Install...");
        button.setLayoutData((Object)LayoutUtils.createGD((Button)button));
        SelectionAdapter defaultUpdate = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PkgTab.this.doUpdateLatest();
            }
        };
        DropDownButton button2 = new DropDownButton(composite);
        Menu menu = button2.getDropDownMenu();
        MenuItem item = new MenuItem(menu, 8);
        item.setText("&Update (default)...");
        item.addSelectionListener((SelectionListener)defaultUpdate);
        item = new MenuItem(menu, 8);
        item.setText("&Reinstall...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PkgTab.this.doReinstall(null);
            }
        });
        this.updateButton = button2;
        button2.setText("Update...");
        button2.addSelectionListener((SelectionListener)defaultUpdate);
        button2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.uninstallButton = button = new Button(composite, 8);
        button.setText("Uninstall");
        button.setLayoutData((Object)LayoutUtils.createGD((Button)button));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        this.loadButton = button = new Button(composite, 8);
        button.setText("Load");
        button.setLayoutData((Object)LayoutUtils.createGD((Button)button));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == PkgTab.this.installButton) {
                    PkgTab.this.doInstall();
                } else if (e.getSource() == PkgTab.this.updateButton) {
                    PkgTab.this.doUpdateLatest();
                } else if (e.getSource() == PkgTab.this.uninstallButton) {
                    PkgTab.this.doUninstall();
                } else if (e.getSource() == PkgTab.this.loadButton) {
                    PkgTab.this.doLoad();
                }
            }
        };
        this.installButton.addSelectionListener((SelectionListener)listener);
        this.uninstallButton.addSelectionListener((SelectionListener)listener);
        this.updateButton.addSelectionListener((SelectionListener)listener);
        this.loadButton.addSelectionListener((SelectionListener)listener);
    }

    private void createDetailInfo(Composite parent) {
        Group info = new Group(parent, 0);
        info.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        info.setLayout((Layout)LayoutUtils.newGroupGrid((int)2, (boolean)true));
        info.setText("Info");
        Composite properties = new Composite((Composite)info, 0);
        properties.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        properties.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(properties, 0);
        label.setText("License:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.detailLicense = new Label(properties, 0);
        this.detailLicense.setText("                ");
        this.detailLicense.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite col = new Composite((Composite)info, 0);
        col.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.createDetailRef(col, 0);
        col.setLayoutData((Object)new GridData(4, 4, true, true));
        col = new Composite((Composite)info, 0);
        col.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.createDetailRef(col, 1);
        col.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createDetailRef(Composite parent, int type) {
        Label label = new Label(parent, 0);
        label.setText(type == 0 ? "Dependencies:" : "Reverse:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        TreeViewer viewer = new TreeViewer(parent, 2052);
        if (type == 0) {
            this.detailDepTable = viewer;
        } else {
            this.detailRevTable = viewer;
        }
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = LayoutUtils.hintHeight((Tree)viewer.getTree(), (int)12);
        gd.widthHint = this.dialog.hintWidthInChars(20);
        viewer.getControl().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)new DetailGroup.ContentProvider(5){
            private static final int DEPENDS = 0;
            private static final int IMPORTS = 1;
            private static final int LINKINGTO = 2;
            private static final int SUGGESTS = 3;
            private static final int ENHANCES = 4;
            {
                this.groups[0] = new DetailGroup(0, "Depends");
                this.groups[1] = new DetailGroup(1, "Imports");
                this.groups[2] = new DetailGroup(2, "Linking To");
                this.groups[3] = new DetailGroup(3, "Suggests");
                this.groups[4] = new DetailGroup(4, "Enhances");
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof IRPkgData) {
                    IRPkgData pkg = (IRPkgData)newInput;
                    this.groups[0].setList(pkg.getDepends());
                    this.groups[1].setList(pkg.getImports());
                    this.groups[2].setList(pkg.getLinkingTo());
                    this.groups[3].setList(pkg.getSuggests());
                    this.groups[4].setList(pkg.getEnhances());
                } else {
                    this.groups[0].clearList();
                    this.groups[1].clearList();
                    this.groups[2].clearList();
                    this.groups[3].clearList();
                    this.groups[4].clearList();
                }
            }
        });
        viewer.setAutoExpandLevel(-1);
        viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof DetailGroup) {
                    cell.setText(((DetailGroup)element).getLabel());
                    cell.setStyleRanges(null);
                    return;
                }
                if (element instanceof RPkg) {
                    RPkg pkg = (RPkg)element;
                    StyledString text = new StyledString();
                    text.append(pkg.getName());
                    String version = pkg.getVersion().toString();
                    if (!version.isEmpty()) {
                        text.append(" (", StyledString.QUALIFIER_STYLER);
                        text.append(version, StyledString.QUALIFIER_STYLER);
                        text.append(")", StyledString.QUALIFIER_STYLER);
                    }
                    cell.setText(text.getString());
                    cell.setStyleRanges(text.getStyleRanges());
                    return;
                }
                throw new IllegalStateException();
            }
        });
        viewer.setInput((Object)RPkgManagerDialog.NO_INPUT);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof RPkg) {
                    PkgTab.this.showPkg(((RPkg)element).getName());
                }
            }
        });
    }

    void createActions() {
        this.serviceLocator = new NestedServices(this.dialog.getServiceLocator(), "Tab");
        this.serviceLocator.bindTo((Control)this);
        this.handlers = new ContextHandlers(this.serviceLocator.getLocator());
        AbstractHandler handler = new AbstractHandler(){

            public void setEnabled(Object evaluationContext) {
                IStatus status = PkgTab.this.dialog.getStatus();
                this.setBaseEnabled(status != null && status.isOK());
            }

            public Object execute(ExecutionEvent event) throws ExecutionException {
                IStatus status = PkgTab.this.dialog.getStatus();
                if (status != null && status.isOK()) {
                    PkgTab.this.dialog.doApply(true);
                }
                return null;
            }
        };
        this.handlers.addActivate("org.eclipse.ui.file.refresh", (IHandler2)handler);
        this.toolBar.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(this.serviceLocator.getLocator(), null, "org.eclipse.ui.file.refresh", 8), (IHandler2)handler));
        this.toolBar.add((IContributionItem)new Separator());
        this.pkgHistory.addActions(this.serviceLocator.getLocator(), this.handlers, this.toolBar);
        this.toolBar.update(true);
    }

    TabItem getTab() {
        return this.tab;
    }

    void addBinding(DataBindingSupport db) {
        this.filterPrioritySet = new WritableSet(db.getRealm(), Collections.emptySet(), String.class);
        db.getContext().bindSet(ViewerProperties.checkedElements(String.class).observe((Object)this.filterPriorityTable), this.filterPrioritySet);
        new AutoCheckController(this.filterPriorityTable, this.filterPrioritySet);
        this.filterRViewsSet = new WritableSet(db.getRealm(), Collections.emptySet(), IRView.class);
        db.getContext().bindSet(ViewerProperties.checkedElements(IRView.class).observe((Object)this.filterRViewsTable), this.filterRViewsSet);
        new AutoCheckController(this.filterRViewsTable, this.filterRViewsSet);
        this.filterController = new TableFilterController(this.pkgTable.viewer);
        this.filterController.addFilter((IElementFilter)new InstalledFilter());
        SetElementFilter filter = new SetElementFilter(){

            protected boolean select(Collection<?> set, Object element) {
                String name = (String)element;
                if (Util.hasPkgPriority((RPkgCompilation<? extends IRPkgData>)PkgTab.this.pkgSet.getAvailable(), name, set)) {
                    return true;
                }
                return Util.hasPkgPriority((RPkgCompilation<? extends IRPkgData>)PkgTab.this.pkgSet.getInstalled(), name, set);
            }
        };
        this.filterController.addFilter((IElementFilter)filter);
        new ObservableSetBinding(this.filterController, this.filterPrioritySet, filter){

            protected Collection<?> getAll() {
                return PkgTab.this.pkgSet.getPriorities();
            }
        };
        filter = new SetElementFilter();
        this.filterController.addFilter((IElementFilter)filter);
        new ObservableSetBinding(this.filterController, this.filterRViewsSet, filter){

            protected Collection<?> createFilterSet(Collection<?> set) {
                HashSet pkgNames = new HashSet(set.size() * 50);
                for (IRView view : set) {
                    pkgNames.addAll(view.getPkgList());
                }
                return pkgNames;
            }
        };
        filter = new TextElementFilter();
        this.filterController.addFilter((IElementFilter)filter);
        new SearchTextBinding(this.filterText, this.filterController, (TextElementFilter)filter);
        this.filterController.addListener(new TableFilterController.Listener(){

            public void inputUpdated(boolean newInput) {
                if (newInput) {
                    PkgTab.this.selectedPkgVersion = null;
                    PkgTab.this.updateDetail();
                }
            }
        });
        this.pkgTable.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List list = ((IStructuredSelection)event.getSelection()).toList();
                PkgTab.this.doUpdateDetail(list.toArray(new String[list.size()]));
            }
        });
        this.detailTable.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection treeSelection = (ITreeSelection)event.getSelection();
                Object element = treeSelection.getFirstElement();
                PkgTab.this.updateDetailDetail(element instanceof IRPkgData ? treeSelection.getPaths()[0] : null);
            }
        });
    }

    private void clearFilter() {
        this.filterController.startUpdate();
        try {
            this.filterText.clearText();
            this.filterInstButton.setSelection(false);
            this.filterNotInstButton.setSelection(false);
            this.filterPrioritySet.clear();
            this.filterRViewsSet.clear();
        }
        finally {
            this.filterController.endUpdate();
        }
    }

    public void updateSettings(IRPkgManager.Ext pkgManager) {
        this.filterController.startUpdate();
        try {
            Composite show;
            this.pkgSet = pkgManager.getExtRPkgSet();
            if (this.pkgSet == null) {
                this.pkgSet = IRPkgSet.DUMMY;
            }
            this.selectedPkgVersion = null;
            List priorities = this.pkgSet.getPriorities();
            this.filterPriorityTable.setInput((Object)priorities);
            this.filterPrioritySet.retainAll((Collection)priorities);
            List views = pkgManager.getRViews();
            if (views != null) {
                this.filterRViewsTable.setInput((Object)views);
                this.filterRViewsSet.retainAll((Collection)views);
                show = this.filterRViewsTable.getControl().getParent();
            } else {
                this.filterRViewsTable.setInput((Object)Collections.EMPTY_LIST);
                this.filterRViewsSet.clear();
                if (this.pkgSet.getAvailable().contains("ctv") && !this.pkgSet.getInstalled().contains("ctv")) {
                    this.filterViewsMessage.setText("Install CRAN Task Views (<a href=\"ctv\">ctv</a>) package to filter the packages by tasks.");
                    show = this.filterViewsMessage;
                } else {
                    show = this.filterRViewsTable.getControl().getParent();
                }
            }
            if (this.filterViewsStack.topControl != show) {
                this.filterViewsStack.topControl = show;
                show.getParent().layout(true);
            }
            this.filterController.setInput(this.pkgSet.getNames());
        }
        finally {
            this.filterController.endUpdate();
        }
    }

    private void updateDetail() {
        List list = ((IStructuredSelection)this.pkgTable.viewer.getSelection()).toList();
        this.doUpdateDetail(list.toArray(new String[list.size()]));
    }

    private void doUpdateDetail(String[] selection) {
        if (selection.length == 1) {
            String name;
            this.selectedPkgName = name = selection[0];
            this.detailTable.viewer.setInput((Object)name);
            ITreeSelection treeSelection = (ITreeSelection)this.detailTable.viewer.getSelection();
            Object element = treeSelection.getFirstElement();
            if (!(element instanceof IRPkgData)) {
                String repoId;
                IRPkgData pkg = null;
                if (pkg == null && (repoId = this.selectedPkgVersions.get(name)) != null) {
                    pkg = Util.getPkgByRepo((RPkgCompilation<? extends IRPkgData>)this.pkgSet.getAvailable(), name, repoId);
                }
                if (pkg == null) {
                    pkg = (IRPkgData)this.pkgSet.getAvailable().getFirst(name);
                }
                if (pkg == null) {
                    pkg = (IRPkgData)this.pkgSet.getInstalled().getFirst(name);
                }
                if (pkg != null) {
                    this.detailTable.viewer.setSelection((ISelection)new StructuredSelection((Object)pkg));
                }
            }
            if (this.selectedPkgVersion == null && (element = (treeSelection = (ITreeSelection)this.detailTable.viewer.getSelection()).getFirstElement()) instanceof IRPkgData) {
                this.updateDetailDetail(treeSelection.getPaths()[0]);
            }
            this.pkgHistory.selected((Object)name);
            this.toolBar.update(true);
        } else {
            this.selectedPkgName = null;
            this.detailTable.viewer.setInput((Object)RPkgManagerDialog.NO_INPUT);
            this.pkgHistory.selected(null);
        }
    }

    private void updateDetailDetail(TreePath path) {
        if (this.selectedPkgName != null && path != null) {
            IRPkgData first;
            String name = this.selectedPkgName;
            int id = ((DetailGroup)path.getFirstSegment()).getId();
            IRPkgData pkg = (IRPkgData)path.getLastSegment();
            this.selectedPkgVersionGroup = id;
            this.selectedPkgVersion = pkg;
            if (!pkg.getRepoId().isEmpty() && (first = (IRPkgData)this.pkgSet.getAvailable().getFirst(name)) != null && !pkg.getRepoId().equals(first.getRepoId())) {
                this.selectedPkgVersions.put(name, pkg.getRepoId());
            } else {
                this.selectedPkgVersions.remove(name);
            }
            this.detailLicense.setText(pkg.getLicense());
            this.detailDepTable.setInput((Object)pkg);
            this.detailRevTable.setInput((Object)this.pkgSet.getReverse(name));
        } else {
            this.selectedPkgVersionGroup = -1;
            this.selectedPkgVersion = null;
            this.detailLicense.setText("");
            this.detailDepTable.setInput((Object)RPkgManagerDialog.NO_INPUT);
            this.detailRevTable.setInput((Object)RPkgManagerDialog.NO_INPUT);
        }
        this.updateButtons();
    }

    private boolean isModifiable(RLibLocation libLocation) {
        RLibLocationInfo info = this.rPkgManager.getRLibPaths().getInfo(libLocation);
        return info != null && info.isWritable();
    }

    private void updateButtons() {
        boolean allRemovable;
        boolean allInstalled;
        boolean available;
        if (this.selectedPkgName != null) {
            String name = this.selectedPkgName;
            available = this.pkgSet.getAvailable().contains(name);
            IRPkgInfoAndData pkg = (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
            if (pkg != null) {
                allInstalled = true;
                allRemovable = this.isModifiable(pkg.getLibLocation());
            } else {
                allInstalled = false;
                allRemovable = false;
            }
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.pkgTable.viewer.getSelection();
            if (selection.isEmpty()) {
                available = false;
                allInstalled = false;
                allRemovable = false;
            } else {
                available = false;
                allInstalled = true;
                allRemovable = true;
                ArrayList<String> checkedLocations = new ArrayList<String>(8);
                for (String name : selection) {
                    if (!available && this.pkgSet.getAvailable().contains(name)) {
                        available = true;
                    }
                    if (!allInstalled) continue;
                    IRPkgInfoAndData pkg = (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
                    if (pkg != null) {
                        RLibLocation libLoc;
                        if (!allRemovable || checkedLocations.contains((libLoc = pkg.getLibLocation()).getDirectory())) continue;
                        allRemovable = this.isModifiable(libLoc);
                        checkedLocations.add(libLoc.getDirectory());
                        continue;
                    }
                    allInstalled = false;
                    allRemovable = false;
                }
            }
        }
        this.installButton.setEnabled(available);
        this.updateButton.setEnabled(available);
        this.uninstallButton.setEnabled(allRemovable);
        this.loadButton.setEnabled(allInstalled);
    }

    void updateStatus(IStatus status) {
        this.handlers.update(null);
    }

    private void doInstall() {
        Map<String, List<RPkgAction.Install>> pkgs = this.getFirstSelectedAsActions(false, new IGetPkgFilter[0]);
        if (pkgs == null) {
            return;
        }
        RPkgResolver resolver = new RPkgResolver(this.pkgSet, pkgs);
        resolver.setAddSuggested(this.dialog.getOptionsTab().installSuggested());
        resolver.run();
        InstallPkgsWizard wizard = new InstallPkgsWizard((Tool)this.dialog.getTool(), this.rPkgManager, 1, resolver);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.open();
        this.pkgTable.viewer.refresh(true);
        this.updateButtons();
    }

    private void doUpdateLatest() {
        Map<String, List<RPkgAction.Install>> pkgs = this.getFirstSelectedAsActions(false, new IGetPkgFilter[]{new RequireInstFilter(), new LibSourceFilter(), new LaterVersionFilter()});
        if (pkgs == null) {
            return;
        }
        RPkgResolver resolver = new RPkgResolver(this.pkgSet, pkgs);
        resolver.setAddSuggested(false);
        resolver.run();
        InstallPkgsWizard wizard = new InstallPkgsWizard((Tool)this.dialog.getTool(), this.rPkgManager, 2, resolver);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.open();
        this.pkgTable.viewer.refresh(true);
        this.updateButtons();
    }

    private void doReinstall(List<String> names) {
        Map<String, List<RPkgAction.Install>> pkgs = this.getAllSelectedAsActions(names, true, new IGetPkgFilter[]{new RequireInstFilter(), new LibSourceFilter(), new NotOlderVersionFilter(), new ReadOnlyFilter(this.rPkgManager.getRLibPaths())});
        if (pkgs == null) {
            return;
        }
        RPkgResolver resolver = new RPkgResolver(this.pkgSet, pkgs);
        resolver.setAddRequired(false);
        resolver.run();
        InstallPkgsWizard wizard = new InstallPkgsWizard((Tool)this.dialog.getTool(), this.rPkgManager, 3, resolver);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.open();
        this.pkgTable.viewer.refresh(true);
        this.updateButtons();
    }

    private void doUninstall() {
        List<IRPkgInfoAndData> pkgs = this.getSelectedInstalled(new IGetPkgFilter[]{new RequireInstFilter(), new LibSourceFilter(), new ReadOnlyFilter(this.rPkgManager.getRLibPaths())});
        if (pkgs == null) {
            return;
        }
        ArrayList<RPkgAction.Uninstall> actions = new ArrayList<RPkgAction.Uninstall>(pkgs.size());
        for (IRPkgInfoAndData pkg : pkgs) {
            actions.add(new RPkgAction.Uninstall((IRPkgInfo)pkg));
        }
        this.rPkgManager.perform((Tool)this.dialog.getTool(), actions);
        this.pkgTable.viewer.refresh(true);
        this.updateButtons();
    }

    private void doLoad() {
        List<IRPkgInfoAndData> pkgs = this.getSelectedInstalled(new IGetPkgFilter[]{new RequireInstFilter()});
        if (pkgs == null) {
            return;
        }
        if (pkgs.size() == 1 && this.selectedPkgVersion != null) {
            this.rPkgManager.loadPkgs((Tool)this.dialog.getTool(), pkgs, true);
        } else {
            this.rPkgManager.loadPkgs((Tool)this.dialog.getTool(), pkgs, false);
        }
    }

    private List<IRPkgInfoAndData> getSelectedInstalled(IGetPkgFilter[] filters) {
        if (this.selectedPkgName != null) {
            String name = this.selectedPkgName;
            IRPkgInfoAndData inst = this.selectedPkgVersionGroup == 1 ? (IRPkgInfoAndData)this.selectedPkgVersion : (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
            int j = 0;
            while (j < filters.length) {
                if (filters[j].exclude(inst, null)) {
                    return null;
                }
                ++j;
            }
            ArrayList<IRPkgInfoAndData> list = new ArrayList<IRPkgInfoAndData>(1);
            list.add(inst);
            return list;
        }
        IStructuredSelection selection = (IStructuredSelection)this.pkgTable.viewer.getSelection();
        ArrayList<IRPkgInfoAndData> list = new ArrayList<IRPkgInfoAndData>(selection.size());
        block1: for (Object element : selection.toList()) {
            String name = (String)element;
            IRPkgInfoAndData inst = (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
            int j = 0;
            while (j < filters.length) {
                if (filters[j].exclude(inst, null)) continue block1;
                ++j;
            }
            list.add(inst);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private final Map<String, List<RPkgAction.Install>> getFirstSelectedAsActions(boolean sameRepo, IGetPkgFilter[] filters) {
        if (this.selectedPkgName != null) {
            String name = this.selectedPkgName;
            IRPkgData avail = this.selectedPkgVersionGroup == 0 ? this.selectedPkgVersion : (IRPkgData)this.pkgSet.getAvailable().getFirst(name);
            if (avail == null) {
                return null;
            }
            IRPkgInfoAndData inst = this.selectedPkgVersionGroup == 1 ? (IRPkgInfoAndData)this.selectedPkgVersion : (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
            if (inst != null && sameRepo) {
                avail = this.getAvailSameRepo(inst, avail);
            }
            int j = 0;
            while (j < filters.length) {
                if (filters[j].exclude(inst, avail)) {
                    return null;
                }
                ++j;
            }
            ArrayList<RPkgAction.Install> list = new ArrayList<RPkgAction.Install>(1);
            list.add(new RPkgAction.Install(avail, null, inst));
            return Collections.singletonMap(name, list);
        }
        IStructuredSelection selection = (IStructuredSelection)this.pkgTable.viewer.getSelection();
        HashMap<String, List<RPkgAction.Install>> map = new HashMap<String, List<RPkgAction.Install>>(selection.size());
        block1: for (Object element : selection.toList()) {
            String name = (String)element;
            IRPkgData avail = (IRPkgData)this.pkgSet.getAvailable().getFirst(name);
            if (avail == null) continue;
            IRPkgInfoAndData inst = (IRPkgInfoAndData)this.pkgSet.getInstalled().getFirst(name);
            if (inst != null && sameRepo) {
                avail = this.getAvailSameRepo(inst, avail);
            }
            int j = 0;
            while (j < filters.length) {
                if (filters[j].exclude(inst, avail)) continue block1;
                ++j;
            }
            ArrayList<RPkgAction.Install> list = new ArrayList<RPkgAction.Install>(1);
            list.add(new RPkgAction.Install(avail, null, inst));
            map.put(name, list);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private final Map<String, List<RPkgAction.Install>> getAllSelectedAsActions(List<String> names, boolean sameRepo, IGetPkgFilter[] filters) {
        if (names == null && this.selectedPkgName != null) {
            String name = this.selectedPkgName;
            IRPkgData avail = this.selectedPkgVersionGroup == 0 ? this.selectedPkgVersion : (IRPkgData)this.pkgSet.getAvailable().getFirst(name);
            if (avail == null) {
                return null;
            }
            List instList = this.pkgSet.getInstalled().get(name);
            if (instList.isEmpty()) {
                return null;
            }
            ArrayList<RPkgAction.Install> list = new ArrayList<RPkgAction.Install>(instList.size());
            block0: for (IRPkgInfoAndData inst : instList) {
                IRPkgData instAvail = sameRepo ? this.getAvailSameRepo(inst, avail) : avail;
                int j = 0;
                while (j < filters.length) {
                    if (filters[j].exclude(inst, instAvail)) continue block0;
                    ++j;
                }
                list.add(new RPkgAction.Install(instAvail, null, inst));
            }
            if (list.isEmpty()) {
                return null;
            }
            return Collections.singletonMap(name, list);
        }
        if (names == null) {
            names = ((IStructuredSelection)this.pkgTable.viewer.getSelection()).toList();
        }
        HashMap<String, List<RPkgAction.Install>> map = new HashMap<String, List<RPkgAction.Install>>(names.size());
        for (String name : names) {
            List instList;
            IRPkgData avail = (IRPkgData)this.pkgSet.getAvailable().getFirst(name);
            if (avail == null || (instList = this.pkgSet.getInstalled().get(name)).isEmpty()) continue;
            ArrayList<RPkgAction.Install> list = new ArrayList<RPkgAction.Install>(instList.size());
            block3: for (IRPkgInfoAndData inst : instList) {
                IRPkgData instAvail = sameRepo ? this.getAvailSameRepo(inst, avail) : avail;
                int j = 0;
                while (j < filters.length) {
                    if (filters[j].exclude(inst, instAvail)) continue block3;
                    ++j;
                }
                list.add(new RPkgAction.Install(instAvail, null, inst));
            }
            if (list.isEmpty()) continue;
            map.put(name, list);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private IRPkgData getAvailSameRepo(IRPkgInfoAndData inst, IRPkgData fallback) {
        RPkgList repoList;
        IRPkgData pkg = null;
        if (!inst.getRepoId().isEmpty() && (repoList = this.pkgSet.getAvailable().getBySource(inst.getRepoId())) != null && (pkg = (IRPkgData)repoList.get(inst.getName())) != null) {
            return pkg;
        }
        return fallback;
    }

    void showPkg(String name) {
        if (name.equals("R")) {
            return;
        }
        this.filterController.setSelection((Object)name);
    }

    IRPkgSet.Ext getPkgSet() {
        return this.pkgSet;
    }

    void install(final List<String> pkgNames) {
        this.pkgTable.viewer.setSelection((ISelection)new StructuredSelection());
        this.clearFilter();
        this.filterController.schedule(new Runnable(){

            @Override
            public void run() {
                PkgTab.this.filterController.setSelection(pkgNames);
                PkgTab.this.doInstall();
            }
        });
    }

    void reinstallAll() {
        this.doReinstall(this.pkgSet.getNames());
    }

    private class InstalledFilter
    implements IElementFilter,
    SelectionListener {
        private static final int INSTALLED = 1;
        private static final int NOT_INSTALLED = 2;
        private volatile int state;
        private Final filter;

        public InstalledFilter() {
            PkgTab.this.filterInstButton.addSelectionListener((SelectionListener)this);
            PkgTab.this.filterNotInstButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == PkgTab.this.filterInstButton) {
                PkgTab.this.filterNotInstButton.setSelection(false);
            } else if (e.getSource() == PkgTab.this.filterNotInstButton) {
                PkgTab.this.filterInstButton.setSelection(false);
            }
            int state = PkgTab.this.filterInstButton.getSelection() ? 1 : (PkgTab.this.filterNotInstButton.getSelection() ? 2 : 0);
            if (this.state != state) {
                this.state = state;
                PkgTab.this.filterController.refresh(true);
            }
        }

        public IElementFilter.IFinalFilter getFinal(boolean newData) {
            int state = this.state;
            if (state == 0) {
                this.filter = null;
            } else if (this.filter == null || this.filter.state != state) {
                this.filter = new Final(state);
            }
            return this.filter;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private class Final
        implements IElementFilter.IFinalFilter {
            private final int state;

            public Final(int state) {
                this.state = state;
            }

            public boolean select(Object element) {
                boolean installed = ((InstalledFilter)InstalledFilter.this).PkgTab.this.pkgSet.getInstalled().contains((String)element);
                if ((this.state & 1) != 0) {
                    return installed;
                }
                return !installed;
            }

            public boolean isSubOf(IElementFilter.IFinalFilter other) {
                return other == this || other == null || other instanceof Final && this.state == ((Final)other).state;
            }

            public boolean isEqualTo(IElementFilter.IFinalFilter other) {
                return other == this || other instanceof Final && this.state == ((Final)other).state;
            }
        }
    }
}

