/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.core.source;

import org.eclipse.statet.docmlet.tex.core.source.LtxPartitionNodeScanner;
import org.eclipse.statet.docmlet.tex.core.source.LtxPartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.WrappedPartitionNodeScan;
import org.eclipse.statet.r.core.source.RPartitionNodeScanner;
import org.eclipse.statet.r.core.source.RPartitionNodeType;
import org.eclipse.statet.redocs.tex.r.core.source.RChunkPartitionNodeScanner;

public class LtxRweavePartitionNodeScanner
extends LtxPartitionNodeScanner {
    protected static final int S_RVERB = 11;
    protected static final int S_RCHUNK = 12;
    private static final LtxPartitionNodeType.VerbatimInline SEXPR_LTX_TYPE = new LtxPartitionNodeType.VerbatimInline('}'){

        public byte getScannerState() {
            return 11;
        }
    };
    private static final LtxPartitionNodeType RCHUNK_LTX_TYPE = new LtxPartitionNodeType(){

        public String getPartitionType() {
            return "RweaveChunk.Base";
        }

        public byte getScannerState() {
            return 12;
        }
    };
    private static final char[] SEQ_Sexpr = "Sexpr".toCharArray();
    private final RChunkPartitionNodeScanner rScanner = new RChunkPartitionNodeScanner();
    private WrappedPartitionNodeScan rScan;
    private int rStartOffset;
    private TreePartitionNode rStartNode;

    public LtxRweavePartitionNodeScanner() {
    }

    public LtxRweavePartitionNodeScanner(boolean templateMode) {
        super(templateMode);
    }

    public void execute(TreePartitionNodeScan scan) {
        this.rScan = new WrappedPartitionNodeScan(scan);
        super.execute(scan);
        this.rScan = null;
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof RPartitionNodeType) {
            this.rStartOffset = this.getScan().getStartOffset();
            this.rStartNode = beginNode;
            TreePartitionNode rRootNode = RPartitionNodeScanner.findRRootNode((TreePartitionNode)beginNode);
            if (rRootNode.getType() == RChunkPartitionNodeScanner.R_CHUNK_BASE_TYPE) {
                this.initNode(rRootNode, RCHUNK_LTX_TYPE);
            } else {
                this.initNode(rRootNode, (LtxPartitionNodeType)SEXPR_LTX_TYPE);
            }
            return;
        }
        this.rStartNode = null;
        super.init();
    }

    protected void handleNewLine(LtxPartitionNodeType type) {
        if (this.reader.readTemp('<', '<')) {
            if (type == RCHUNK_LTX_TYPE) {
                assert (this.rStartNode != null);
                return;
            }
            assert (this.rStartNode == null);
            this.rStartOffset = this.reader.getOffset();
            this.addNode((TreePartitionNodeType)RChunkPartitionNodeScanner.R_CHUNK_BASE_TYPE, RCHUNK_LTX_TYPE, this.rStartOffset);
            this.rStartNode = this.getNode();
        }
    }

    protected boolean searchExtCommand(int c) {
        if (c == 83 && this.reader.readConsuming2(SEQ_Sexpr)) {
            this.reader.readConsumingWhitespace();
            if (this.reader.read('{')) {
                assert (this.rStartNode == null);
                this.rStartOffset = this.reader.getOffset();
                this.addNode((TreePartitionNodeType)this.rScanner.getDefaultRootType(), (LtxPartitionNodeType)SEXPR_LTX_TYPE, this.rStartOffset);
                this.rStartNode = this.getNode();
                this.processExt((LtxPartitionNodeType)SEXPR_LTX_TYPE);
                return true;
            }
        }
        return false;
    }

    protected void processExt(LtxPartitionNodeType type) {
        switch (type.getScannerState()) {
            case 11: {
                TreePartitionNode node = this.rStartNode;
                this.rStartNode = null;
                this.processInline();
                if (node.getLength() > 0) {
                    this.rScan.init(this.rStartOffset, node.getEndOffset(), node);
                    this.rScanner.execute((TreePartitionNodeScan)this.rScan);
                    this.rScan.exit();
                }
                return;
            }
            case 12: {
                TreePartitionNode node = this.rStartNode;
                this.rStartNode = null;
                this.rScan.init(this.rStartOffset, this.rScan.getDocument().getLength(), node);
                this.rScanner.execute((TreePartitionNodeScan)this.rScan);
                this.rScan.exit();
                TreePartitionNode chunkNode = this.getNode();
                this.exitNode();
                this.setRange(chunkNode.getEndOffset(), this.getScan().getDocument().getLength());
                return;
            }
        }
        super.processExt(type);
    }

    protected void processInline() {
        int expandVar = 0;
        block7: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.reader.read('\n');
                    this.last = 2;
                    return;
                }
                case 10: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.last = 2;
                    return;
                }
                case 123: {
                    if (!this.reader.read('{')) continue block7;
                    ++expandVar;
                    continue block7;
                }
                case 125: {
                    if (expandVar > 0 && this.reader.read('}')) {
                        --expandVar;
                        continue block7;
                    }
                    this.exitNode(this.reader.getOffset() - 1, 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }
}

