/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.processing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.internal.docmlet.base.ui.DocmlBaseUIPlugin;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DocProcessingRegistry
implements Disposable {
    private static final String EXTENSION_POINT_ID = "org.eclipse.statet.docmlet.DocProcessing";
    private static final String PROCESSING_TYPE_ELEMENT_NAME = "processingType";
    private static final String CONTENT_TYPE_ID_ATTR_NAME = "contentTypeId";
    private static final String CONFIG_TYPE_ID_ATTR_NAME = "configTypeId";
    private static final String MANAGER_CLASS_ATTR_NAME = "managerClass";
    private final Map<String, TypeEntry> entries = this.loadEntries();

    private Map<String, TypeEntry> loadEntries() {
        IConfigurationElement[] elements;
        HashMap<String, TypeEntry> entries = new HashMap<String, TypeEntry>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String contentTypeId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(PROCESSING_TYPE_ELEMENT_NAME) && (contentTypeId = element.getAttribute(CONTENT_TYPE_ID_ATTR_NAME)) != null && !contentTypeId.isEmpty()) {
                TypeEntry item = new TypeEntry(contentTypeId, element);
                entries.put(item.getContentTypeId(), item);
            }
            ++n2;
        }
        return entries;
    }

    public @Nullable DocProcessingManager getDocProcessingManager(String contentTypeId) {
        TypeEntry item = this.entries.get(contentTypeId);
        return item != null ? item.getManager() : null;
    }

    public void dispose() {
        for (TypeEntry entry : this.entries.values()) {
            entry.dispose();
        }
    }

    public static class ManagerConfig {
        public final String contentTypeId;
        public final String configTypeId;

        public ManagerConfig(String contentTypeId, String configTypeId) {
            this.contentTypeId = contentTypeId;
            this.configTypeId = configTypeId;
        }
    }

    private static class TypeEntry {
        private static final byte S_MANAGER_FAILED = 1;
        private static final byte S_DISPOSED = -128;
        private final String contentTypeId;
        private final IConfigurationElement element;
        private byte state;
        private @Nullable DocProcessingManager manager;

        public TypeEntry(String contentTypeId, IConfigurationElement element) {
            this.contentTypeId = contentTypeId.intern();
            this.element = element;
        }

        public String getContentTypeId() {
            return this.contentTypeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable DocProcessingManager getManager() {
            DocProcessingManager manager = this.manager;
            if (manager == null) {
                TypeEntry typeEntry = this;
                synchronized (typeEntry) {
                    block7: {
                        manager = this.manager;
                        if (manager != null || (this.state & 0xFFFFFF81) != 0) break block7;
                        try {
                            ManagerConfig config = new ManagerConfig(this.contentTypeId, this.element.getAttribute(DocProcessingRegistry.CONFIG_TYPE_ID_ATTR_NAME));
                            manager = (DocProcessingManager)((Object)this.element.createExecutableExtension(DocProcessingRegistry.MANAGER_CLASS_ATTR_NAME));
                            manager.init(config);
                            this.manager = manager;
                        }
                        catch (CoreException e) {
                            this.state = (byte)(this.state | 1);
                            DocmlBaseUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred when loading document processing type ''{0}''.", (Object)this.getContentTypeId()), (Throwable)e));
                            return null;
                        }
                    }
                }
            }
            return manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            TypeEntry typeEntry = this;
            synchronized (typeEntry) {
                this.state = (byte)(this.state | 0xFFFFFF80);
                DocProcessingManager manager = this.manager;
                if (manager != null) {
                    manager.dispose();
                    this.manager = null;
                }
            }
        }
    }
}

