/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupBracketPairMatcher;
import org.eclipse.statet.docmlet.wikitext.core.source.WikidocDocumentContentInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextDocumentConstants;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextHeuristicTokenScanner;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.MarkupTokenScanner;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.StyleConfig;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikidocQuickAssistProcessor;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.docmlet.wikitext.ui.WikitextUIPlugin;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.DocQuickOutlineInformationProvider;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupAutoEditStrategy;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupDamagerRepairer;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupDoubleClickStrategy;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.WikitextContentAssistProcessor;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class WikidocSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    public static final int FIXED_LINE_HEIGHT_STYLE = 0x100000;
    private static final String[] CONTENT_TYPES = (String[])WikitextDocumentConstants.WIKIDOC_CONTENT_TYPES.toArray((Object[])new String[WikitextDocumentConstants.WIKIDOC_CONTENT_TYPES.size()]);
    protected ITextDoubleClickStrategy doubleClickStrategy;
    private MarkupAutoEditStrategy autoEditStrategy;
    private WikitextCoreAccess coreAccess;

    private static final int checkFlags(int flags) {
        if ((flags & 0x10) != 0) {
            flags |= 0x100000;
        }
        return flags;
    }

    public WikidocSourceViewerConfiguration(int flags) {
        this((DocContentSections)WikidocDocumentContentInfo.INSTANCE, flags, null, null, null);
    }

    public WikidocSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor editor, WikitextCoreAccess access, IPreferenceStore preferenceStore) {
        super(documentContentInfo, WikidocSourceViewerConfiguration.checkFlags(flags), editor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : WikitextEditingSettings.getPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), WikitextEditingSettings.getAssistPreferences());
    }

    protected void setCoreAccess(WikitextCoreAccess access) {
        this.coreAccess = access != null ? access : WikitextCore.getWorkbenchAccess();
    }

    protected StyleConfig createStyleConfig() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        FontRegistry fontRegistry = themeManager.getCurrentTheme().getFontRegistry();
        return new StyleConfig(fontRegistry.get("org.eclipse.mylyn.wikitext.ui.presentation.textFont"), fontRegistry.get("org.eclipse.mylyn.wikitext.ui.presentation.monospaceFont"), (this.getFlags() & 0x100000) != 0);
    }

    protected void initScanners() {
        this.addScanner("Wikitext.Default", new MarkupTokenScanner(this.getConfiguredDocumentPartitioning(null), this.createStyleConfig()));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType == "Html.Default" || contentType == "Html.Comment") {
            contentType = "Wikitext.Default";
        }
        return super.getScanner(contentType);
    }

    protected void initPresentationReconciler(PresentationReconciler reconciler) {
        MarkupDamagerRepairer dr = new MarkupDamagerRepairer(this.getScanner("Wikitext.Default"));
        reconciler.setDamager((IPresentationDamager)dr, "Wikitext.Default");
        reconciler.setRepairer((IPresentationRepairer)dr, "Wikitext.Default");
        reconciler.setDamager((IPresentationDamager)dr, "Html.Default");
        reconciler.setRepairer((IPresentationRepairer)dr, "Html.Default");
        reconciler.setDamager((IPresentationDamager)dr, "Html.Comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "Html.Comment");
    }

    public List<SourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.autoEditStrategy != null) {
            addons.add(this.autoEditStrategy);
        }
        return addons;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        if (this.autoEditStrategy != null) {
            this.autoEditStrategy.getSettings().handleSettingsChanged(groupIds, options);
        }
        if (groupIds.contains("org.eclipse.statet.docmlet.wikitext.ui/textstyle/Wikitext")) {
            MarkupTokenScanner scanner = (MarkupTokenScanner)this.getScanner("Wikitext.Default");
            scanner.setStyleConfig(this.createStyleConfig());
            options.put("affects.Presentation", Boolean.TRUE);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public ICharPairMatcher createPairMatcher() {
        return new MarkupBracketPairMatcher(WikitextHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new MarkupDoubleClickStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return this.doubleClickStrategy;
    }

    protected IIndentSettings getIndentSettings() {
        return this.coreAccess.getWikitextCodeStyle();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"<!--", ""};
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(WikitextEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoEditStrategy};
    }

    protected MarkupAutoEditStrategy createAutoEditStrategy() {
        return new MarkupAutoEditStrategy(this.coreAccess, this.getSourceEditor());
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        SourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2(editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        return reconciler;
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = WikitextUIPlugin.getInstance().getWikidocEditorContentAssistRegistry();
        WikitextContentAssistProcessor processor = new WikitextContentAssistProcessor(assistant, "Wikitext.Default", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Wikitext.Default");
    }

    protected IQuickAssistProcessor createQuickAssistProcessor() {
        SourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new WikidocQuickAssistProcessor(editor);
        }
        return null;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.docmlet.editorHyperlinks.WikitextEditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        SourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new DocQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }
}

