/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.collections;

import java.nio.channels.UnsupportedAddressTypeException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.statet.ecommons.collections.IntMap;

public final class IntHashMap<V>
implements IntMap<V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<V>[] fEntries;
    private int fSize;
    private int fThreshold;
    private final float fLoadFactor;
    private volatile Set<IntMap.IntEntry<V>> fEntryIntSet;

    public IntHashMap() {
        this(16, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.fLoadFactor = loadFactor;
        this.fThreshold = (int)((float)initialCapacity * this.fLoadFactor);
        this.fEntries = new Entry[initialCapacity];
    }

    private int idxFor(int key) {
        int compr = key ^ key >>> 23 ^ key >>> 11;
        return ((compr ^ compr >>> 7) & Integer.MAX_VALUE) % this.fEntries.length;
    }

    @Override
    public boolean isEmpty() {
        return this.fSize == 0;
    }

    @Override
    public int size() {
        return this.fSize;
    }

    @Override
    public boolean containsKey(int key) {
        Entry<V> e = this.fEntries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof Integer && this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        int i = this.fEntries.length - 1;
        while (i >= 0) {
            Entry<V> e = this.fEntries[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        return false;
    }

    @Override
    public V get(int key) {
        Entry<V> e = this.fEntries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return key instanceof Integer ? (V)this.get((Integer)key) : null;
    }

    private void increase() {
        Entry<V>[] oldEntries = this.fEntries;
        this.fEntries = new Entry[oldEntries.length * 2 + 1];
        int i = oldEntries.length - 1;
        while (i >= 0) {
            Entry<V> next = oldEntries[i];
            while (next != null) {
                Entry<V> e = next;
                next = next.next;
                int idx = this.idxFor(e.key);
                e.next = this.fEntries[idx];
                this.fEntries[idx] = e;
            }
            --i;
        }
        this.fThreshold = (int)((float)this.fEntries.length * this.fLoadFactor);
    }

    @Override
    public V put(int key, V value) {
        Entry<V> e = this.fEntries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.fSize >= this.fThreshold) {
            this.increase();
        }
        int idx = this.idxFor(key);
        this.fEntries[idx] = new Entry<V>(key, value, this.fEntries[idx]);
        ++this.fSize;
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> t) {
        for (Map.Entry<Integer, V> entry : t.entrySet()) {
            this.put((int)entry.getKey(), entry.getValue());
        }
    }

    public V remove(int key) {
        int idx = this.idxFor(key);
        Entry<V> e = this.fEntries[idx];
        Entry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev == null) {
                    this.fEntries[idx] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.fSize;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return key instanceof Integer ? (V)this.remove((Integer)key) : null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.fEntries, null);
        this.fSize = 0;
    }

    public Set<IntMap.IntEntry<V>> entryIntSet() {
        AbstractSet entries = this.fEntryIntSet;
        return entries != null ? entries : (this.fEntryIntSet = new AbstractSet<IntMap.IntEntry<V>>(){

            @Override
            public int size() {
                return IntHashMap.this.fSize;
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof IntMap.IntEntry && o.equals(IntHashMap.this.get(((IntMap.IntEntry)o).getIntKey()));
            }

            @Override
            public Iterator<IntMap.IntEntry<V>> iterator() {
                return new IntEntryIterator();
            }

            @Override
            public void clear() {
                IntHashMap.this.clear();
            }
        });
    }

    @Override
    public Set<Integer> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        throw new UnsupportedAddressTypeException();
    }

    private static class Entry<V>
    implements Map.Entry<Integer, V>,
    IntMap.IntEntry<V> {
        final int key;
        V value;
        Entry<V> next;

        public Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.key + (this.value != null ? this.value.hashCode() : 0);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntMap.IntEntry)) {
                return false;
            }
            IntMap.IntEntry other = (IntMap.IntEntry)obj;
            return this.key == other.getIntKey() && (this.value != null ? this.value.equals(other.getValue()) : other.getValue() == null);
        }
    }

    private class IntEntryIterator
    implements Iterator<IntMap.IntEntry<V>> {
        private Entry<V> fCurrentEntry;
        private Entry<V> fNextEntry;
        private int fNextEntryIdx;

        public IntEntryIterator() {
            int idx = 0;
            while (idx < IntHashMap.this.fEntries.length) {
                if (IntHashMap.this.fEntries[idx] != null) {
                    this.fNextEntryIdx = idx;
                    this.fNextEntry = IntHashMap.this.fEntries[this.fNextEntryIdx];
                    break;
                }
                ++idx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.fNextEntry != null;
        }

        @Override
        public Entry<V> next() {
            this.fCurrentEntry = this.fNextEntry;
            if (this.fCurrentEntry == null) {
                throw new NoSuchElementException();
            }
            if (this.fCurrentEntry.next != null) {
                this.fNextEntry = this.fCurrentEntry.next;
            } else {
                this.fNextEntry = null;
                int idx = this.fNextEntryIdx + 1;
                while (idx < IntHashMap.this.fEntries.length) {
                    if (IntHashMap.this.fEntries[idx] != null) {
                        this.fNextEntryIdx = idx;
                        this.fNextEntry = IntHashMap.this.fEntries[this.fNextEntryIdx];
                        break;
                    }
                    ++idx;
                }
            }
            return this.fCurrentEntry;
        }

        @Override
        public void remove() {
            if (this.fCurrentEntry == null) {
                throw new IllegalStateException();
            }
            IntHashMap.this.remove(this.fCurrentEntry.key);
            this.fCurrentEntry = null;
        }
    }
}

