/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class ShortedLabel {
    private static final Pattern fLineBreakPattern = Pattern.compile("\\r[\\n]?|\\n");
    private String fText;
    private String fCheckedText;
    private final Label fLabel;
    private String fLineBreakReplacement = " ";

    public ShortedLabel(Composite parent, int style) {
        this.fLabel = new Label(parent, style);
        this.fLabel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ShortedLabel.this.updateShortening();
            }
        });
    }

    public Label getControl() {
        return this.fLabel;
    }

    public void setText(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        if (label.equals(this.fText)) {
            return;
        }
        this.fText = label;
        this.updateChecking();
        this.updateShortening();
    }

    public void setLineBreakReplacement(String s) {
        assert (s != null);
        this.fLineBreakReplacement = s;
        if (this.fText != null) {
            this.updateChecking();
        }
    }

    private void updateChecking() {
        this.fCheckedText = fLineBreakPattern.matcher(this.fText).replaceAll(this.fLineBreakReplacement);
    }

    private void updateShortening() {
        Shorter shorter = new Shorter((Control)this.fLabel);
        try {
            String text = shorter.shorten(this.fCheckedText);
            this.fLabel.setText(text);
            this.fLabel.setToolTipText(text == this.fCheckedText ? null : this.fText);
        }
        finally {
            shorter.dispose();
        }
    }

    private static class Shorter {
        private static final String ELLIPSIS = " ... ";
        private static final int DRAW_FLAGS = 4;
        Control fControl;
        GC fGC;
        int fMaxWidth;
        String fText;

        public Shorter(Control control) {
            this.fControl = control;
        }

        public void dispose() {
            GC gc = this.fGC;
            if (gc != null) {
                this.fGC = null;
                gc.dispose();
            }
        }

        public String shorten(String text) {
            if (text == null || text.isEmpty()) {
                return text;
            }
            if (this.fGC == null) {
                this.fGC = new GC((Drawable)this.fControl);
                this.fMaxWidth = this.fControl.getBounds().width;
            }
            if (this.fGC.textExtent((String)text, (int)4).x <= this.fMaxWidth) {
                return text;
            }
            this.fText = text;
            String shortedText = this.doShorten();
            this.fText = null;
            return shortedText;
        }

        private String doShorten() {
            double avgCharWidth = this.fGC.getFontMetrics().getAverageCharacterWidth();
            int textLength = this.fText.length();
            int ellipsisWidth = this.fGC.textExtent((String)ELLIPSIS, (int)4).x;
            int max2 = (this.fMaxWidth - ellipsisWidth) * 42 / 100;
            if ((double)max2 < avgCharWidth * 3.0) {
                max2 = 0;
            }
            int e = Math.max(textLength - (int)((double)max2 / avgCharWidth), 0);
            int w2 = this.measurePart2(e);
            while (w2 > max2 && e < textLength) {
                w2 = this.measurePart2(e++);
            }
            while (e > 0) {
                int test = this.measurePart2(e - 1);
                if (test > max2) break;
                --e;
                w2 = test;
            }
            int max1 = this.fMaxWidth - ellipsisWidth - w2;
            int s = Math.min((int)((double)max2 / avgCharWidth), textLength);
            int w1 = this.measurePart1(s);
            while (w1 > max1 && s > 3) {
                w1 = this.measurePart1(s--);
            }
            while (s < textLength) {
                int test = this.measurePart1(s + 1);
                if (test > max1) break;
                ++s;
                w1 = test;
            }
            return String.valueOf(this.fText.substring(0, s)) + ELLIPSIS + this.fText.substring(e, textLength);
        }

        private int measurePart1(int end) {
            return this.fGC.textExtent((String)this.fText.substring((int)0, (int)end), (int)4).x;
        }

        private int measurePart2(int start) {
            return this.fGC.textExtent((String)this.fText.substring((int)start), (int)4).x;
        }
    }
}

