/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.labeled;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CornerGridLineCellLayerPainter
extends CellLayerPainter {
    private final Color gridColor;

    public CornerGridLineCellLayerPainter(Color gridColor) {
        this.gridColor = gridColor;
    }

    public CornerGridLineCellLayerPainter() {
        this.gridColor = GUIHelper.COLOR_GRAY;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    private ILayer getCornerLayer(ILayer layer) {
        return layer.getUnderlyingLayerByPosition(0L, 0L).getUnderlyingLayerByPosition(0L, 0L);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.drawGridLines(natLayer, gc, rectangle);
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle bounds) {
        return new LRectangle(bounds.x, bounds.y, bounds.width - 1L, bounds.height - 1L);
    }

    protected void drawGridLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        gc.setForeground(this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        ILayerDim colDim = natLayer.getDim(Orientation.HORIZONTAL);
        int startX = GraphicsUtils.safe((long)rectangle.x + colDim.getPositionStart(this.getCornerLayer(natLayer).getColumnCount() - 1L) - 1L);
        int endX = GraphicsUtils.safe((long)rectangle.x + Math.min(colDim.getSize() - 1L, (long)rectangle.width));
        ILayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long lastPosition = CornerGridLineCellLayerPainter.getEndPosition(dim, rectangle.y + rectangle.height) - 1L;
        if (startX < endX) {
            long position = dim.getPositionByPixel(rectangle.y);
            while (position < lastPosition) {
                int size = dim.getPositionSize(position);
                if (size > 0) {
                    int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)dim.getPositionSize(position) - 1L);
                    gc.drawLine(startX, y, endX, y);
                }
                ++position;
            }
        }
        int y = GraphicsUtils.safe(dim.getPositionStart(lastPosition) + (long)dim.getPositionSize(lastPosition) - 1L);
        gc.drawLine(GraphicsUtils.safe(rectangle.x), y, endX, y);
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        ILayerDim rowDim = natLayer.getDim(Orientation.VERTICAL);
        int startY = GraphicsUtils.safe((long)rectangle.y + rowDim.getPositionStart(this.getCornerLayer(natLayer).getRowCount() - 1L) - 1L);
        int endY = GraphicsUtils.safe((long)rectangle.y + Math.min(rowDim.getSize() - 1L, (long)rectangle.height));
        ILayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long lastPosition = CornerGridLineCellLayerPainter.getEndPosition(dim, rectangle.x + rectangle.width) - 1L;
        if (startY < endY) {
            long position = dim.getPositionByPixel(rectangle.x);
            while (position < lastPosition) {
                int size = dim.getPositionSize(position);
                if (size > 0) {
                    int x = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                    gc.drawLine(x, startY, x, endY);
                }
                ++position;
            }
        }
        int x = GraphicsUtils.safe(dim.getPositionStart(lastPosition) + (long)dim.getPositionSize(lastPosition) - 1L);
        gc.drawLine(x, GraphicsUtils.safe(rectangle.y), x, endY);
    }
}

