/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.matcher;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public class CellPainterMouseEventMatcher
extends MouseEventMatcher {
    private ICellPainter targetCellPainter;
    private Class<? extends ICellPainter> targetCellPainterClass;

    public CellPainterMouseEventMatcher(String regionName, int button, ICellPainter targetCellPainter) {
        super(regionName, button);
        this.targetCellPainter = targetCellPainter;
    }

    public CellPainterMouseEventMatcher(String regionName, int button, Class<? extends ICellPainter> targetCellPainterClass) {
        super(regionName, button);
        this.targetCellPainterClass = targetCellPainterClass;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        long rowPosition;
        long columnPosition;
        ILayerCell cell;
        if (super.matches(natTable, event, regionLabels) && (cell = natTable.getCellByPosition(columnPosition = natTable.getColumnPositionByX(event.x), rowPosition = natTable.getRowPositionByY(event.y))) != null) {
            IConfigRegistry configRegistry = natTable.getConfigRegistry();
            ICellPainter cellPainter = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
            GC gc = new GC((Drawable)natTable.getDisplay());
            try {
                LRectangle adjustedCellBounds = natTable.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
                ICellPainter clickedCellPainter = cellPainter.getCellPainterAt(event.x, event.y, cell, gc, adjustedCellBounds, configRegistry);
                if (clickedCellPainter != null && (this.targetCellPainter != null && this.targetCellPainter == clickedCellPainter || this.targetCellPainterClass != null && this.targetCellPainterClass.isInstance(clickedCellPainter))) {
                    return true;
                }
            }
            finally {
                gc.dispose();
            }
        }
        return false;
    }
}

