/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.core.builder.RTaskMarkerHandler;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManagerImpl;
import org.eclipse.statet.internal.r.core.sourcemodel.RReconciler;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RBuildReconciler
extends RReconciler {
    private final RTaskMarkerHandler taskScanner = new RTaskMarkerHandler();
    private MultiStatus statusCollector;

    public RBuildReconciler(RModelManagerImpl manager) {
        super(manager);
    }

    public void init(RProject project, MultiStatus status) throws CoreException {
        this.taskScanner.init(project);
        this.statusCollector = status;
    }

    public RSourceUnitModelInfo build(RSourceUnitModelContainer adapter, IProgressMonitor monitor) {
        int type;
        RSourceUnit su = (RSourceUnit)adapter.getSourceUnit();
        int n = type = su.getModelTypeId().equals("R") ? su.getElementType() : 0;
        if (type == 0) {
            return null;
        }
        if (this.stop || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        RReconciler.Data data = new RReconciler.Data(adapter, monitor);
        if (data.content == null) {
            return null;
        }
        if (this.stop || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateAst(data, monitor);
        if (this.stop || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateModel(data);
        if (this.stop || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            List<RAstNode> comments = ((SourceComponent)data.ast.getRoot()).getComments();
            this.taskScanner.setup(data.content, (IResource)su.getResource());
            for (RAstNode comment : comments) {
                this.taskScanner.checkForTasks(comment.getStartOffset() + 1, comment.getEndOffset());
            }
        }
        catch (Exception e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "Failed to create task marker(s).", (Throwable)e));
        }
        if (this.stop || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return data.newModel;
    }
}

