/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.io.ObjectInput;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RArrayImpl;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RCharacterFix64Store;
import org.eclipse.statet.rj.data.impl.RCharacterStructStore;
import org.eclipse.statet.rj.data.impl.RComplexB32Store;
import org.eclipse.statet.rj.data.impl.RComplexBFix64Store;
import org.eclipse.statet.rj.data.impl.RComplexStructStore;
import org.eclipse.statet.rj.data.impl.RDataFrame32Impl;
import org.eclipse.statet.rj.data.impl.REnvironmentImpl;
import org.eclipse.statet.rj.data.impl.RFactor32Store;
import org.eclipse.statet.rj.data.impl.RFactorFix64Store;
import org.eclipse.statet.rj.data.impl.RFactorStructStore;
import org.eclipse.statet.rj.data.impl.RFunctionImpl;
import org.eclipse.statet.rj.data.impl.RInteger32Store;
import org.eclipse.statet.rj.data.impl.RIntegerFix64Store;
import org.eclipse.statet.rj.data.impl.RIntegerStructStore;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.data.impl.RList32Impl;
import org.eclipse.statet.rj.data.impl.RListFix64Impl;
import org.eclipse.statet.rj.data.impl.RLogicalByte32Store;
import org.eclipse.statet.rj.data.impl.RLogicalByteFix64Store;
import org.eclipse.statet.rj.data.impl.RLogicalStructStore;
import org.eclipse.statet.rj.data.impl.RMissingImpl;
import org.eclipse.statet.rj.data.impl.RNullImpl;
import org.eclipse.statet.rj.data.impl.RNumericB32Store;
import org.eclipse.statet.rj.data.impl.RNumericBFix64Store;
import org.eclipse.statet.rj.data.impl.RNumericStructStore;
import org.eclipse.statet.rj.data.impl.ROtherImpl;
import org.eclipse.statet.rj.data.impl.RPromiseImpl;
import org.eclipse.statet.rj.data.impl.RRaw32Store;
import org.eclipse.statet.rj.data.impl.RRawFix64Store;
import org.eclipse.statet.rj.data.impl.RRawStructStore;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.data.impl.RS4ObjectImpl;
import org.eclipse.statet.rj.data.impl.RVectorImpl;

@NonNullByDefault
public class DefaultRObjectFactory
implements RObjectFactory {
    public static final DefaultRObjectFactory INSTANCE = new DefaultRObjectFactory();
    public static final RNumericStore NUM_STRUCT_DUMMY = new RNumericStructStore();
    public static final RComplexStructStore CPLX_STRUCT_DUMMY = new RComplexStructStore();
    public static final RIntegerStructStore INT_STRUCT_DUMMY = new RIntegerStructStore();
    public static final RLogicalStructStore LOGI_STRUCT_DUMMY = new RLogicalStructStore();
    public static final RRawStructStore RAW_STRUCT_DUMMY = new RRawStructStore();
    public static final RCharacterStructStore CHR_STRUCT_DUMMY = new RCharacterStructStore();
    private final long storeLengthFixLong = 0x10000000L;

    public <TData extends RStore<?>> RVector<TData> createVector(TData data, String classname) {
        return new RVectorImpl<TData>(data, classname);
    }

    @Override
    public <TData extends RStore<?>> RVector<TData> createVector(TData data) {
        return this.createVector(data, data.getBaseVectorRClassName());
    }

    public RVector<RLogicalStore> createLogiVector(boolean[] logicals) {
        return this.createVector(this.createLogiData(logicals), "logical");
    }

    public RVector<RLogicalStore> createLogiVector(int length) {
        return this.createVector(this.createLogiData(length), "logical");
    }

    public RVector<RIntegerStore> createIntVector(int[] integers) {
        return this.createVector(this.createIntData(integers), "integer");
    }

    public RVector<RIntegerStore> createIntVector(int length) {
        return this.createVector(this.createIntData(length), "integer");
    }

    public RVector<RNumericStore> createNumVector(double[] numerics) {
        return this.createVector(this.createNumData(numerics), "numeric");
    }

    public RVector<RNumericStore> createNumVector(int length) {
        return this.createVector(this.createNumData(length), "numeric");
    }

    public RVector<RComplexStore> createCplxVector(int length) {
        return this.createVector(this.createCplxData(length), "complex");
    }

    public RVector<RCharacterStore> createCharVector(@Nullable String[] characters) {
        return this.createVector(this.createCharData(characters), "character");
    }

    public RVector<RCharacterStore> createCharVector(int length) {
        return this.createVector(this.createCharData(length), "character");
    }

    public RVector<RRawStore> createRawVector(byte[] raws) {
        return this.createVector(this.createRawData(raws), "raw");
    }

    public RVector<RRawStore> createRawVector(int length) {
        return this.createVector(this.createRawData(length), "raw");
    }

    public RVector<RFactorStore> createFactorVector(int[] codes, String[] levels) {
        return this.createVector(this.createFactorData(codes, levels), "factor");
    }

    public RVector<RFactorStore> createFactorVector(int length, String[] levels) {
        return this.createVector(this.createFactorData(length, levels), "factor");
    }

    public RVector<RFactorStore> createOrderedVector(int[] codes, String[] levels) {
        return this.createVector(this.createOrderedData(codes, levels), "ordered");
    }

    public RVector<RFactorStore> createOrderedVector(int length, String[] levels) {
        return this.createVector(this.createOrderedData(length, levels), "ordered");
    }

    public <TData extends RStore<?>> RArray<TData> createArray(TData data, int[] dim, String classname) {
        return new RArrayImpl<TData>(data, classname, dim);
    }

    @Override
    public <TData extends RStore<?>> RArray<TData> createArray(TData data, int[] dim) {
        return this.createArray(data, dim, dim.length == 2 ? "matrix" : "array");
    }

    @Override
    public <TData extends RStore<?>> RArray<TData> createMatrix(TData data, int dim1, int dim2) {
        return this.createArray(data, new int[]{dim1, dim2}, "matrix");
    }

    public RArray<RLogicalStore> createLogiArray(boolean[] logicals, int[] dim) {
        return this.createArray(this.createLogiData(logicals), dim);
    }

    public RArray<RLogicalStore> createLogiArray(int[] dim) {
        return this.createArray(this.createLogiData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    public RArray<RIntegerStore> createIntArray(int[] integers, int[] dim) {
        return this.createArray(this.createIntData(integers), dim);
    }

    public RArray<RIntegerStore> createIntArray(int[] dim) {
        return this.createArray(this.createIntData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    public RArray<RNumericStore> createNumArray(double[] numerics, int[] dim) {
        return this.createArray(this.createNumData(numerics), dim);
    }

    public RArray<RNumericStore> createNumArray(int[] dim) {
        return this.createArray(this.createNumData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    public RArray<RCharacterStore> createCharArray(@Nullable String[] characters, int[] dim) {
        return this.createArray(this.createCharData(characters), dim);
    }

    public RArray<RCharacterStore> createCharArray(int[] dim) {
        return this.createArray(this.createCharData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    public RArray<RLogicalStore> createLogiMatrix(boolean[] logicals, int dim1, int dim2) {
        return this.createMatrix(this.createLogiData(logicals), dim1, dim2);
    }

    public RArray<RLogicalStore> createLogiMatrix(int dim1, int dim2) {
        return this.createMatrix(this.createLogiData(dim1 * dim2), dim1, dim2);
    }

    public RArray<RIntegerStore> createIntMatrix(int[] integers, int dim1, int dim2) {
        return this.createMatrix(this.createIntData(integers), dim1, dim2);
    }

    public RArray<RIntegerStore> createIntMatrix(int dim1, int dim2) {
        return this.createMatrix(this.createIntData(dim1 * dim2), dim1, dim2);
    }

    public RArray<RNumericStore> createNumMatrix(double[] numerics, int dim1, int dim2) {
        return this.createMatrix(this.createNumData(numerics), dim1, dim2);
    }

    public RArray<RNumericStore> createNumMatrix(int dim1, int dim2) {
        return this.createMatrix(this.createNumData(dim1 * dim2), dim1, dim2);
    }

    public RArray<RCharacterStore> createCharMatrix(@Nullable String[] characters, int dim1, int dim2) {
        return this.createMatrix(this.createCharData(characters), dim1, dim2);
    }

    public RArray<RCharacterStore> createCharMatrix(int dim1, int dim2) {
        return this.createMatrix(this.createCharData(dim1 * dim2), dim1, dim2);
    }

    public RDataFrame createDataFrame(@NonNull RStore<?>[] colDatas, @NonNull String[] colNames) {
        return this.createDataFrame(colDatas, colNames, null);
    }

    public RDataFrame createDataFrame(@NonNull RStore<?>[] colDatas, @NonNull String[] colNames, String @Nullable [] rowNames) {
        RObject[] colVectors = new RObject[colDatas.length];
        int i = 0;
        while (i < colVectors.length) {
            colVectors[i] = this.createVector(colDatas[i]);
            ++i;
        }
        return this.createDataFrame(colVectors, colNames, rowNames);
    }

    public RDataFrame createDataFrame(RObject[] colVectors, @NonNull String[] colNames, String @Nullable [] rowNames) {
        return new RDataFrame32Impl(colVectors, "data.frame", colNames, rowNames);
    }

    public RList createList(RObject[] components, @Nullable String @Nullable [] names, String classname) {
        return new RList32Impl(components, classname, names);
    }

    @Override
    public RList createList(RObject[] components, @Nullable String @Nullable [] names) {
        return this.createList(components, names, "list");
    }

    @Override
    public RLanguage createName(String name) {
        return new RLanguageImpl(1, name, "name");
    }

    @Override
    public RLanguage createExpression(String expr) {
        return new RLanguageImpl(2, expr, "expression");
    }

    @Override
    public RLogicalStore createLogiData(boolean[] logiValues) {
        return new RLogicalByte32Store(logiValues);
    }

    public RLogicalStore createLogiData(long length) {
        return length <= 0x10000000L ? new RLogicalByte32Store((int)length) : new RLogicalByteFix64Store(length);
    }

    @Override
    public RIntegerStore createIntData(int[] intValues) {
        return new RInteger32Store(intValues);
    }

    public RIntegerStore createIntData(long length) {
        return length <= 0x10000000L ? new RInteger32Store((int)length) : new RIntegerFix64Store(length);
    }

    @Override
    public RNumericStore createNumData(double[] numValues) {
        return new RNumericB32Store(numValues);
    }

    public RNumericStore createNumData(long length) {
        return length <= 0x10000000L ? new RNumericB32Store((int)length) : new RNumericBFix64Store(length);
    }

    @Override
    public RComplexStore createCplxData(double[] reValues, double[] imValues) {
        return new RComplexB32Store(reValues, imValues, null);
    }

    public RComplexStore createCplxData(long length) {
        return length <= 0x10000000L ? new RComplexB32Store((int)length) : new RComplexBFix64Store(length);
    }

    @Override
    public RCharacterStore createCharData(@Nullable String[] charValues) {
        return new RCharacter32Store(charValues);
    }

    public RCharacterStore createCharData(long length) {
        return length <= 0x10000000L ? new RCharacter32Store((int)length) : new RCharacterFix64Store(length);
    }

    @Override
    public RRawStore createRawData(byte[] rawValues) {
        return new RRaw32Store(rawValues);
    }

    public RRawStore createRawData(long length) {
        return length <= 0x10000000L ? new RRaw32Store((int)length) : new RRawFix64Store(length);
    }

    @Override
    public RFactorStore createFactorData(int[] codes, String[] levels) {
        return new RFactor32Store(codes, false, levels);
    }

    public RFactorStore createFactorData(int length, String[] levels) {
        return new RFactor32Store(length, false, levels);
    }

    public RFactorStore createOrderedData(int[] codes, String[] levels) {
        return new RFactor32Store(codes, true, levels);
    }

    public RFactorStore createOrderedData(int length, String[] levels) {
        return new RFactor32Store(length, true, levels);
    }

    @Override
    public RObject readObject(RJIO io) throws IOException {
        byte type = io.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 1: {
                return RNullImpl.INSTANCE;
            }
            case 2: {
                return new RVectorImpl(io, this);
            }
            case 3: {
                return new RArrayImpl(io, this);
            }
            case 7: {
                int options = io.readInt();
                return (options & 7) <= 3 ? new RList32Impl(io, this, options) : new RListFix64Impl(io, this, options);
            }
            case 6: {
                int options = io.readInt();
                return (options & 7) <= 3 ? new RDataFrame32Impl(io, this, options) : new RListFix64Impl(io, this, options);
            }
            case 8: {
                return new REnvironmentImpl(io, this);
            }
            case 12: {
                return new RLanguageImpl(io, this);
            }
            case 13: {
                return new RFunctionImpl(io, this);
            }
            case 14: {
                return new RReferenceImpl(io, this);
            }
            case 10: {
                return new RS4ObjectImpl(io, this);
            }
            case 15: {
                return new ROtherImpl(io, this);
            }
            case 17: {
                return RMissingImpl.INSTANCE;
            }
            case 18: {
                if ((io.flags & 4) != 0) {
                    return new RPromiseImpl(io, this);
                }
                return RPromiseImpl.INSTANCE;
            }
        }
        throw new IOException("object type= " + type);
    }

    @Override
    public void writeObject(RObject robject, RJIO io) throws IOException {
        if (robject == null) {
            io.writeByte(-1);
            return;
        }
        byte type = robject.getRObjectType();
        io.writeByte(type);
        switch (type) {
            case 1: 
            case 17: {
                return;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                ((ExternalizableRObject)((Object)robject)).writeExternal(io, this);
                return;
            }
        }
        throw new IOException("object type= " + type);
    }

    @Override
    public RStore<?> readStore(RJIO io, long length) throws IOException {
        if ((io.flags & 1) == 0) {
            byte storeType = io.readByte();
            if (length <= Integer.MAX_VALUE) {
                switch (storeType) {
                    case 1: {
                        return new RLogicalByte32Store(io, (int)length);
                    }
                    case 2: {
                        return new RInteger32Store(io, (int)length);
                    }
                    case 3: {
                        return new RNumericB32Store(io, (int)length);
                    }
                    case 4: {
                        return new RComplexB32Store(io, (int)length);
                    }
                    case 5: {
                        return new RCharacter32Store(io, (int)length);
                    }
                    case 6: {
                        return new RRaw32Store(io, (int)length);
                    }
                    case 10: {
                        return new RFactor32Store(io, (int)length);
                    }
                }
                throw new IOException("store type= " + storeType);
            }
            switch (storeType) {
                case 1: {
                    return new RLogicalByteFix64Store(io, length);
                }
                case 2: {
                    return new RIntegerFix64Store(io, length);
                }
                case 3: {
                    return new RNumericBFix64Store(io, length);
                }
                case 4: {
                    return new RComplexBFix64Store(io, length);
                }
                case 5: {
                    return new RCharacterFix64Store(io, length);
                }
                case 6: {
                    return new RRawFix64Store(io, length);
                }
                case 10: {
                    return new RFactorFix64Store(io, length);
                }
            }
            throw new IOException("store type= " + storeType);
        }
        byte storeType = io.readByte();
        switch (storeType) {
            case 1: {
                return LOGI_STRUCT_DUMMY;
            }
            case 2: {
                return INT_STRUCT_DUMMY;
            }
            case 3: {
                return NUM_STRUCT_DUMMY;
            }
            case 4: {
                return CPLX_STRUCT_DUMMY;
            }
            case 5: {
                return CHR_STRUCT_DUMMY;
            }
            case 6: {
                return RAW_STRUCT_DUMMY;
            }
            case 10: {
                return new RFactorStructStore(io.readBoolean(), io.readInt());
            }
        }
        throw new IOException("store type= " + storeType);
    }

    @Override
    public void writeStore(RStore<?> data, RJIO io) throws IOException {
        if ((io.flags & 1) == 0) {
            io.writeByte(data.getStoreType());
            ((ExternalizableRStore)((Object)data)).writeExternal(io);
        } else {
            byte storeType = data.getStoreType();
            io.writeByte(storeType);
            if (storeType == 10) {
                RFactorStore factor = (RFactorStore)data;
                io.writeBoolean(factor.isOrdered());
                io.writeInt(factor.getLevelCount());
            }
        }
    }

    @Override
    public RList readAttributeList(RJIO io) throws IOException {
        return new RList32Impl(io, this, io.readInt());
    }

    @Override
    public void writeAttributeList(RList list, RJIO io) throws IOException {
        ((ExternalizableRObject)((Object)list)).writeExternal(io, this);
    }

    protected final int[] readDim(ObjectInput in) throws IOException {
        int length = in.readInt();
        int[] dim = new int[length];
        int i = 0;
        while (i < length) {
            dim[i] = in.readInt();
            ++i;
        }
        return dim;
    }

    @Override
    public @Nullable RStore<?> readNames(RJIO io, long length) throws IOException {
        byte type = io.readByte();
        if (type == 5) {
            return length <= Integer.MAX_VALUE ? new RCharacter32Store(io, (int)length) : new RCharacterFix64Store(io, length);
        }
        if (type == 0) {
            return null;
        }
        throw new IOException();
    }

    @Override
    public void writeNames(@Nullable RStore<?> names, RJIO io) throws IOException {
        byte type;
        if (names != null && (type = names.getStoreType()) == 5) {
            io.writeByte(type);
            ((ExternalizableRStore)((Object)names)).writeExternal(io);
            return;
        }
        io.writeByte(0);
    }
}

