/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractComplexStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RComplexB32Store
extends AbstractComplexStore
implements RDataResizeExtension<RComplexStore.Complex>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected double[] realValues;
    protected double[] imaginaryValues;

    public RComplexB32Store() {
        this.length = 0;
        this.realValues = EMPTY_DOUBLE_ARRAY;
        this.imaginaryValues = EMPTY_DOUBLE_ARRAY;
    }

    public RComplexB32Store(int length) {
        this.length = length;
        this.realValues = new double[length];
        this.imaginaryValues = new double[length];
    }

    protected RComplexB32Store(double[] realValues, double[] imaginaryValues) {
        this.length = realValues.length;
        this.realValues = realValues;
        this.imaginaryValues = imaginaryValues;
    }

    public RComplexB32Store(double[] realValues, double[] imaginaryValues, int @Nullable [] naIdxs) {
        if (realValues.length != imaginaryValues.length) {
            throw new IllegalArgumentException();
        }
        this.length = realValues.length;
        this.realValues = realValues;
        this.imaginaryValues = imaginaryValues;
        if (naIdxs != null) {
            int i = 0;
            while (i < naIdxs.length) {
                this.realValues[naIdxs[i]] = NA_numeric_DOUBLE;
                this.imaginaryValues[naIdxs[i]] = NA_numeric_DOUBLE;
                ++i;
            }
        }
    }

    public RComplexB32Store(double[] realValues, double[] imaginaryValues, boolean @Nullable [] isNAs) {
        if (imaginaryValues.length != realValues.length) {
            throw new IllegalArgumentException();
        }
        this.length = realValues.length;
        this.realValues = realValues;
        this.imaginaryValues = imaginaryValues;
        if (isNAs != null) {
            if (isNAs.length != realValues.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < isNAs.length) {
                if (isNAs[i]) {
                    this.realValues[i] = NA_numeric_DOUBLE;
                    this.imaginaryValues[i] = NA_numeric_DOUBLE;
                }
                ++i;
            }
        }
    }

    public RComplexB32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.realValues = io.readDoubleData(new double[length], length);
        this.imaginaryValues = io.readDoubleData(new double[length], length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeDoubleData(this.realValues, this.length);
        io.writeDoubleData(this.imaginaryValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.realValues = new double[this.length];
        this.imaginaryValues = new double[this.length];
        int i = 0;
        while (i < this.length) {
            this.realValues[i] = Double.longBitsToDouble(in.readLong());
            this.imaginaryValues[i] = Double.longBitsToDouble(in.readLong());
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            out.writeLong(Double.doubleToRawLongBits(this.realValues[i]));
            out.writeLong(Double.doubleToRawLongBits(this.imaginaryValues[i]));
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        double v = this.realValues[idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public void setNA(int idx) {
        this.realValues[idx] = NA_numeric_DOUBLE;
        this.imaginaryValues[idx] = NA_numeric_DOUBLE;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.realValues[(int)idx] = NA_numeric_DOUBLE;
        this.imaginaryValues[(int)idx] = NA_numeric_DOUBLE;
    }

    @Override
    public boolean isNaN(int idx) {
        double v = this.realValues[idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isNaN(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double value = this.realValues[(int)idx];
        return Double.isNaN(value) && (int)Double.doubleToRawLongBits(value) != 1954;
    }

    @Override
    public boolean isMissing(int idx) {
        return Double.isNaN(this.realValues[idx]);
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return Double.isNaN(this.realValues[(int)idx]);
    }

    @Override
    public double getCplxRe(int idx) {
        return this.realValues[idx];
    }

    @Override
    public double getCplxRe(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.realValues[(int)idx];
    }

    @Override
    public double getCplxIm(int idx) {
        return this.imaginaryValues[idx];
    }

    @Override
    public double getCplxIm(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.imaginaryValues[(int)idx];
    }

    @Override
    public void setCplx(int idx, double real, double imaginary) {
        if (Double.isNaN(real) || Double.isNaN(imaginary)) {
            this.realValues[idx] = Double.NaN;
            this.imaginaryValues[idx] = Double.NaN;
        } else {
            this.realValues[idx] = real;
            this.imaginaryValues[idx] = imaginary;
        }
    }

    @Override
    public void setCplx(long idx, double real, double imaginary) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        if (Double.isNaN(real) || Double.isNaN(imaginary)) {
            this.realValues[(int)idx] = Double.NaN;
            this.imaginaryValues[(int)idx] = Double.NaN;
        } else {
            this.realValues[(int)idx] = real;
            this.imaginaryValues[(int)idx] = imaginary;
        }
    }

    @Override
    public void setNum(int idx, double real) {
        if (Double.isNaN(real)) {
            this.realValues[idx] = Double.NaN;
            this.imaginaryValues[idx] = Double.NaN;
        } else {
            this.realValues[idx] = real;
            this.imaginaryValues[idx] = 0.0;
        }
    }

    @Override
    public void setNum(long idx, double real) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        if (Double.isNaN(real)) {
            this.realValues[(int)idx] = Double.NaN;
            this.imaginaryValues[(int)idx] = Double.NaN;
        } else {
            this.realValues[(int)idx] = real;
            this.imaginaryValues[(int)idx] = 0.0;
        }
    }

    private void prepareInsert(int[] idxs) {
        this.realValues = RComplexB32Store.prepareInsert(this.realValues, this.length, idxs);
        this.imaginaryValues = RComplexB32Store.prepareInsert(this.imaginaryValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertCplx(int idx, double realValue, double imaginaryValue) {
        this.prepareInsert(new int[]{idx});
        if (Double.isNaN(realValue) || Double.isNaN(imaginaryValue)) {
            this.realValues[idx] = Double.NaN;
            this.imaginaryValues[idx] = Double.NaN;
        } else {
            this.realValues[idx] = realValue;
            this.imaginaryValues[idx] = imaginaryValue;
        }
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.realValues[idx] = NA_numeric_DOUBLE;
        this.imaginaryValues[idx] = NA_numeric_DOUBLE;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.realValues[idx] = NA_numeric_DOUBLE;
            this.imaginaryValues[idx] = NA_numeric_DOUBLE;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.realValues = RComplexB32Store.remove(this.realValues, this.length, new int[]{idx});
        this.imaginaryValues = RComplexB32Store.remove(this.imaginaryValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.realValues = RComplexB32Store.remove(this.realValues, this.length, idxs);
        this.imaginaryValues = RComplexB32Store.remove(this.imaginaryValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public  @Nullable RComplexStore.Complex get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[idx];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? new RComplexStore.Complex(v, this.imaginaryValues[idx]) : null;
    }

    @Override
    public  @Nullable RComplexStore.Complex get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)idx];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? new RComplexStore.Complex(v, this.imaginaryValues[(int)idx]) : null;
    }

    @Override
    public  @Nullable RComplexStore.Complex[] toArray() {
        RComplexStore.Complex[] array = new RComplexStore.Complex[this.length];
        double[] reals = this.realValues;
        double[] imgs = this.imaginaryValues;
        int i = 0;
        while (i < array.length) {
            double v = reals[i];
            if (!Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954) {
                array[i] = new RComplexStore.Complex(v, imgs[i]);
            }
            ++i;
        }
        return array;
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

