/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class FontManager {
    private static final int[] R2SWT_STYLE;
    private static final int R_STYLE_COUNT = 4;
    private static final int HR_FONTSIZE = 60;
    private static final double HR_FACTOR = 60.0;
    private static final int HR_MIN_FONTSIZE = 30;
    private static final int[] EMPTY_INT_ARRY;
    private final Display display;
    private final Object testGCLock = new Object();
    private @Nullable TestGC testGC;
    private boolean disposed;
    private final Map<String, FontFamily> fontFamilies = new HashMap<String, FontFamily>();

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        R2SWT_STYLE = nArray;
        EMPTY_INT_ARRY = new int[0];
    }

    public FontManager(Display display) {
        this.display = display;
    }

    public synchronized FontFamily getFamily(String family) {
        FontFamily fontFamily = this.fontFamilies.get(family);
        if (fontFamily == null) {
            fontFamily = new FontFamily(family);
            this.fontFamilies.put(family, fontFamily);
        }
        return fontFamily;
    }

    protected final Object getTestLock() {
        return this.testGCLock;
    }

    protected final TestGC getTestGC() {
        TestGC testGC = this.testGC;
        if (testGC == null) {
            this.display.syncExec(() -> {
                if (!this.disposed) {
                    this.testGC = new TestGC((Device)this.display);
                }
            });
            testGC = this.testGC;
            if (testGC == null) {
                throw new RuntimeException("disposed");
            }
        }
        return testGC;
    }

    public void dispose() {
        this.disposed = true;
        for (FontFamily fontFamily : this.fontFamilies.values()) {
            fontFamily.dispose();
        }
        this.fontFamilies.clear();
        TestGC testGC = this.testGC;
        if (testGC != null) {
            this.testGC = null;
            testGC.dispose();
        }
    }

    public final class FontFamily {
        private static final double POLISH_SMALL_MAX_FACTOR = 0.4;
        private static final double POLISH_SMALL_ADD_CORR = 0.04;
        private static final double POLISH_ADD_CONST = 0.05;
        private static final double POLISH_ADD_REL = 0.1;
        private static final int METRIC_IDX_ADVWIDTH = 0;
        private static final int METRIC_IDX_ASCENT = 1;
        private static final int METRIC_IDX_DESCENT = 2;
        private static final int METRIC_COUNT = 3;
        final String name;
        final FontInstance[][] fonts = new FontInstance[4][];

        private FontFamily(String name) {
            this.name = name;
        }

        private FontInstance get(int style, int size) {
            int idx;
            FontInstance[] styleFonts = this.fonts[style];
            if (styleFonts == null) {
                styleFonts = new FontInstance[8];
                this.fonts[style] = styleFonts;
            }
            if (size == 60) {
                idx = 0;
            } else {
                idx = styleFonts.length;
                int i = 1;
                while (i < styleFonts.length) {
                    if (styleFonts[i] != null) {
                        if (styleFonts[i].size == size) {
                            idx = i;
                            break;
                        }
                    } else {
                        idx = i;
                        break;
                    }
                    ++i;
                }
                if (idx >= styleFonts.length) {
                    styleFonts = Arrays.copyOf(styleFonts, styleFonts.length + 8);
                    this.fonts[style] = styleFonts;
                }
            }
            FontInstance font = styleFonts[idx];
            if (font == null) {
                FontData fontData = new FontData(this.name, size, R2SWT_STYLE[style]);
                styleFonts[idx] = font = new FontInstance(size, new Font((Device)FontManager.this.display, fontData));
            }
            return font;
        }

        public synchronized Font getSWTFont(int style, int size) {
            return this.get((int)style, (int)size).swtFont;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getCharMetrics(int style, int size, int ch) {
            FontInstance font = this.get(style, 60);
            double factor = (double)size / 60.0;
            int chIdx = font.checkChar(ch) * 3;
            double[] answer = new double[3];
            if (chIdx >= font.charMetrics.length || font.charMetrics[chIdx] == 0.0) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                    if (font.charMetrics.length == 0) {
                        font.charMetrics = new double[Math.max(1536, chIdx + 384)];
                        font.charMetrics[96] = ((double)gc.testGC.getAdvanceWidth('m') * 0.2 + (double)gc.testGC.getAdvanceWidth(' ') * 1.0) / 2.0;
                        font.charMetrics[97] = 0.0;
                        font.charMetrics[98] = 0.0;
                        font.ascentUp = this.checkCharAscentMean(gc, new char[]{'A', 'M', 'O', 'E'});
                        font.ascentLow = this.checkCharAscentMean(gc, new char[]{'a', 'm', 'p', 'w'});
                        font.charMetrics[0] = font.charMetrics[231];
                        font.charMetrics[1] = font.ascentUp > 0.0 ? font.ascentUp : 0.0;
                        font.charMetrics[2] = 0.0;
                    } else if (chIdx >= font.charMetrics.length) {
                        double[] newArray = new double[chIdx + 384];
                        System.arraycopy(font.charMetrics, 0, newArray, 0, font.charMetrics.length);
                        font.charMetrics = newArray;
                    }
                    if (font.charMetrics[chIdx] == 0.0) {
                        this.computeCharHeights(gc, ch, chIdx);
                    }
                }
            }
            answer[0] = this.polish(font.charMetrics[chIdx + 1] + 1.01 / factor, factor);
            answer[1] = this.polish(font.charMetrics[chIdx + 2], factor);
            answer[2] = this.polish(font.charMetrics[chIdx + 0], factor);
            return answer;
        }

        private void computeCharHeights(TestGC gc, int ch, int idx) {
            FontInstance font = gc.getFont();
            font.charMetrics[idx + 0] = gc.testGC.getAdvanceWidth((char)ch);
            String s = String.valueOf((char)ch);
            gc.clearImage();
            gc.drawText(s);
            int firstLine = gc.findFirstLine();
            if (firstLine >= 0) {
                double ascent = font.baseLine - firstLine;
                if (Math.abs(ascent - font.ascentUp) <= font.metricTolerance) {
                    ascent = font.ascentUp;
                } else if (Math.abs(ascent - font.ascentLow) <= font.metricTolerance) {
                    ascent = font.ascentLow;
                }
                int descent = gc.findLastLine() - font.baseLine + 1;
                if ((double)Math.abs(descent) <= font.metricTolerance) {
                    descent = 0;
                }
                font.charMetrics[idx + 1] = ascent;
                font.charMetrics[idx + 2] = descent;
            } else {
                font.charMetrics[idx + 1] = 0.0;
                font.charMetrics[idx + 2] = 0.0;
            }
            if (idx / 3 < font.strWidth.length && font.strWidth[idx / 3] == 0.0) {
                font.strWidth[idx / 3] = gc.getStringWidth(s);
            }
        }

        private double checkCharAscentMean(TestGC gc, char[] chars) {
            FontInstance font = gc.getFont();
            double mean = 0.0;
            int i = 0;
            while (i < chars.length) {
                this.computeCharHeights(gc, chars[i], chars[i] * 3);
                mean += font.charMetrics[chars[i] * 3 + 1];
                gc.testGC.setFont(font.swtFont);
                ++i;
            }
            mean /= (double)chars.length;
            mean = this.polish(mean * 2.0, 1.0) / 2.0;
            i = 0;
            while (i < chars.length) {
                if (Math.abs(mean - font.charMetrics[chars[i] * 3 + 1]) > font.metricTolerance) {
                    return -2.147483648E9;
                }
                ++i;
            }
            i = 0;
            while (i < chars.length) {
                font.charMetrics[chars[i] * 3 + 1] = mean;
                ++i;
            }
            return mean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getStringWidth(int style, int size, String text) {
            int chIdx;
            double factor;
            FontInstance font;
            if (size < 30 && text.length() == 1) {
                font = this.get(style, 60);
                factor = (double)size / 60.0;
                chIdx = font.checkChar(text.charAt(0));
            } else {
                font = this.get(style, size);
                factor = 1.0;
                chIdx = -1;
            }
            double[] answer = new double[]{8 * text.length()};
            if (chIdx < 0 || chIdx >= font.strWidth.length || font.strWidth[chIdx] == 0.0) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    double width;
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                    answer[0] = width = (double)gc.getStringWidth(text);
                    if (chIdx >= 0) {
                        if (font.strWidth.length == 0) {
                            font.strWidth = new double[Math.max(512, chIdx + 256)];
                        } else if (chIdx >= font.strWidth.length) {
                            double[] newWidth = new double[chIdx + 128];
                            System.arraycopy(font.strWidth, 0, newWidth, 0, font.strWidth.length);
                            font.strWidth = newWidth;
                        }
                        font.strWidth[chIdx] = width;
                    }
                }
            } else {
                answer[0] = font.strWidth[chIdx];
            }
            if (factor != 1.0) {
                answer[0] = this.polish(answer[0], factor);
            }
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getSWTFontProperties(int style, int size) {
            FontInstance font = this.get(style, size);
            if (font.swtFontProperties == null) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                }
            }
            return font.swtFontProperties;
        }

        private double polish(double p, double factor) {
            double add;
            if (p == 0.0) {
                return 0.0;
            }
            double d = add = factor < 0.4 ? 0.04 / factor + 0.05 : 0.15;
            if (p > 0.0) {
                return Math.round((p + 0.1) * factor + add);
            }
            return Math.round((p - 0.1) * factor - add);
        }

        public void dispose() {
            int style = 0;
            while (style < 4) {
                FontInstance[] styleFonts = this.fonts[style];
                if (styleFonts != null) {
                    int i = 0;
                    while (i < styleFonts.length) {
                        if (styleFonts[i] != null && styleFonts[i].swtFont != null) {
                            if (!styleFonts[i].swtFont.isDisposed()) {
                                styleFonts[i].swtFont.dispose();
                            }
                            styleFonts[i] = null;
                        }
                        ++i;
                    }
                }
                ++style;
            }
        }
    }

    private static final class FontInstance {
        private static final double[] UNINITIALIZED = new double[0];
        public final int size;
        public final Font swtFont;
        private double[] swtFontProperties;
        private int baseLine;
        private double metricTolerance = 0.0;
        private double ascentUp = -2.147483648E9;
        private double ascentLow = -2.147483648E9;
        private int[] charAbove255 = EMPTY_INT_ARRY;
        private double[] charMetrics = UNINITIALIZED;
        private double[] strWidth = UNINITIALIZED;

        public FontInstance(int size, Font font) {
            this.size = size;
            this.swtFont = font;
        }

        public void init(GC gc) {
            FontMetrics fontMetrics = gc.getFontMetrics();
            this.baseLine = fontMetrics.getLeading() + fontMetrics.getAscent();
            this.metricTolerance = (double)fontMetrics.getAscent() * 0.05;
            this.swtFontProperties = new double[]{this.baseLine};
        }

        public int checkChar(int ch) {
            if (ch <= 0) {
                return 0;
            }
            if (ch <= 255) {
                return ch;
            }
            int[] charAbove255 = this.charAbove255;
            int i = 0;
            while (i < charAbove255.length) {
                int c = charAbove255[i];
                if (c == ch) {
                    return 256 + i;
                }
                if (c == 0) {
                    charAbove255[i] = c;
                    return 256 + i;
                }
                ++i;
            }
            this.charAbove255 = charAbove255 = Arrays.copyOf(charAbove255, i + 256);
            charAbove255[i] = ch;
            return 256 + i;
        }
    }

    private static final class TestGC {
        private final GC testGC;
        private FontInstance font;
        private final Image image;
        private final int imageWidth;
        private final int imageHeigth;
        private final int imagePixelBWidth;
        private final int imagePixelBIndex;
        private final int imageLineBytes;
        private final byte imageBlankData;
        private @Nullable ImageData imageData;

        public TestGC(Device device) {
            GC tempGC = new GC((Drawable)device);
            Font tempFont = new Font(device, new FontData(device.getSystemFont().getFontData()[0].getName(), 60, 0));
            tempGC.setFont(tempFont);
            this.imageHeigth = (int)((double)tempGC.getFontMetrics().getHeight() * 1.5);
            this.imageWidth = this.imageHeigth * 2;
            tempGC.dispose();
            tempFont.dispose();
            this.image = new Image(device, this.imageWidth, this.imageHeigth);
            this.testGC = new GC((Drawable)this.image);
            this.testGC.setAdvanced(true);
            this.testGC.setAntialias(1);
            this.testGC.setTextAntialias(1);
            this.testGC.setInterpolation(2);
            this.testGC.setAlpha(255);
            this.testGC.setBackground(device.getSystemColor(1));
            this.testGC.setForeground(device.getSystemColor(2));
            this.testGC.setFont(null);
            this.font = null;
            this.clearImage();
            ImageData imageData = this.image.getImageData();
            this.imageLineBytes = imageData.bytesPerLine;
            this.imagePixelBWidth = Math.max(imageData.bytesPerLine / imageData.width, 1);
            this.imagePixelBIndex = imageData.palette.isDirect ? this.imagePixelBWidth - 1 + imageData.palette.redShift / 8 : 0;
            this.imageBlankData = imageData.data[this.imagePixelBIndex];
        }

        public void setFont(FontInstance font) {
            this.font = font;
            this.testGC.setFont(font.swtFont);
            if (font.baseLine == 0) {
                font.init(this.testGC);
                this.testGC.setFont(font.swtFont);
            }
        }

        public FontInstance getFont() {
            return this.font;
        }

        public int getStringWidth(String txt) {
            return this.testGC.stringExtent((String)txt).x;
        }

        public void clearImage() {
            this.testGC.fillRectangle(0, 0, this.imageWidth, this.imageHeigth);
            this.imageData = null;
        }

        private ImageData getImageData() {
            ImageData imageData = this.imageData;
            if (imageData == null) {
                this.imageData = imageData = this.image.getImageData();
            }
            return imageData;
        }

        private void drawText(String txt) {
            this.testGC.drawString(txt, 0, 0, true);
        }

        public int findFirstLine() {
            ImageData imageData = this.getImageData();
            byte[] data = imageData.data;
            int index = this.imagePixelBIndex;
            while (index < data.length) {
                if (data[index] != this.imageBlankData) {
                    return index / this.imageLineBytes;
                }
                index += this.imagePixelBWidth;
            }
            return -1;
        }

        public int findLastLine() {
            ImageData imageData = this.getImageData();
            byte[] data = imageData.data;
            int index = data.length - this.imagePixelBWidth + this.imagePixelBIndex;
            while (index >= 0) {
                if (data[index] != this.imageBlankData) {
                    return index / this.imageLineBytes;
                }
                index -= this.imagePixelBWidth;
            }
            return -1;
        }

        public void dispose() {
            if (!this.testGC.isDisposed()) {
                this.testGC.dispose();
            }
            if (!this.image.isDisposed()) {
                this.image.dispose();
            }
        }
    }
}

