/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.AutoIdMap;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.ConsoleMessageCmdItem;
import org.eclipse.statet.rj.server.ConsoleReadCmdItem;
import org.eclipse.statet.rj.server.ConsoleWriteCmdItem;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.DbgCmdItem;
import org.eclipse.statet.rj.server.ExtClientCmdItem;
import org.eclipse.statet.rj.server.GraOpCmdItem;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCtrlCmdItem;
import org.eclipse.statet.rj.server.RjsComObject;

@NonNullByDefault
public final class MainCmdS2CList
implements RjsComObject,
Externalizable {
    static final AutoIdMap<ComHandler> gComHandlers = new AutoIdMap();
    private int id;
    private boolean isBusy;
    private @Nullable MainCmdItem first;

    public MainCmdS2CList(MainCmdItem first, boolean isBusy) {
        this.isBusy = isBusy;
        this.first = first;
    }

    public MainCmdS2CList() {
        this.isBusy = false;
        this.first = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.id);
        out.writeBoolean(this.isBusy);
        RJIO io = RJIO.get((ObjectOutput)out);
        int check = io.writeCheck1();
        MainCmdItem item = this.first;
        if (item != null) {
            do {
                out.writeByte(item.getCmdType());
                item.writeExternal(io);
            } while ((item = item.next) != null);
        }
        out.writeByte(0);
        io.writeCheck2(check);
        io.disconnect(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUnsignedShort();
        if (this.id != 0) {
            gComHandlers.get(this.id).processMainCmd(in);
            return;
        }
        this.isBusy = in.readBoolean();
        RJIO io = RJIO.get((ObjectInput)in);
        try {
            MainCmdItem item;
            int check = io.readCheck1();
            byte cmdType = in.readByte();
            if (cmdType == 0) {
                this.first = null;
                io.readCheck2(check);
                return;
            }
            this.first = item = this.readItem(cmdType, io);
            while (true) {
                if ((cmdType = in.readByte()) == 0) {
                    io.readCheck2(check);
                    return;
                }
                item = item.next = this.readItem(cmdType, io);
            }
        }
        finally {
            io.disconnect(in);
        }
    }

    private MainCmdItem readItem(byte cmdType, RJIO io) throws IOException, ClassNotFoundException {
        switch (cmdType) {
            case 1: {
                return new ConsoleReadCmdItem(io);
            }
            case 2: {
                return new ConsoleWriteCmdItem(io);
            }
            case 4: {
                return new ConsoleMessageCmdItem(io);
            }
            case 5: {
                return new ExtClientCmdItem(io);
            }
            case 16: {
                return new MainCtrlCmdItem(io);
            }
            case 17: {
                return new DataCmdItem(io);
            }
            case 18: {
                return new GraOpCmdItem(io);
            }
            case 20: {
                return new DbgCmdItem(io);
            }
        }
        throw new ClassNotFoundException("Unknown cmdtype id: " + cmdType);
    }

    public void clear() {
        MainCmdItem item = this.first;
        while (item != null) {
            MainCmdItem tmp = item;
            item = item.next;
            tmp.next = null;
        }
        this.first = null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void setId(int id) {
        this.id = (short)id;
    }

    public void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
    }

    public void setObjects(MainCmdItem first) {
        this.first = first;
    }

    @Override
    public int getComType() {
        return 3;
    }

    public MainCmdItem getItems() {
        return this.first;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean testEquals(MainCmdS2CList other) {
        if (this.isBusy != other.isBusy()) {
            return false;
        }
        MainCmdItem thisItem = this.first;
        MainCmdItem otherItem = other.first;
        while (thisItem != null && otherItem != null) {
            if (!thisItem.equals(otherItem)) {
                return false;
            }
            thisItem = thisItem.next;
            otherItem = otherItem.next;
        }
        return thisItem == null && otherItem == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("MainCmdS2CList (isBusy=");
        sb.append(this.isBusy);
        sb.append("):");
        if (this.first == null) {
            sb.append("\n<ITEM/>");
        } else {
            MainCmdItem item = this.first;
            int i = 0;
            while (item != null) {
                sb.append("\n<ITEM i=\"");
                sb.append(i);
                sb.append("\">\n");
                sb.append(item.toString());
                sb.append("\n</ITEM>");
                item = item.next;
                ++i;
            }
        }
        return sb.toString();
    }
}

