/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.rh;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.server.rh.Handle;
import org.eclipse.statet.rj.server.rh.RhDisposable;
import org.eclipse.statet.rj.server.rh.RhEngine;

@NonNullByDefault
public class ParsedExpr
implements RhDisposable {
    private static final int FLAG_DISPOSED = 1;
    private final String source;
    private int flags;
    private @Nullable Handle parsedExpr;

    public ParsedExpr(String source) {
        this.source = source;
    }

    public final String getSource() {
        return this.source;
    }

    public final int getFlags() {
        return this.flags & 0xFFFFFFF;
    }

    public @Nullable Handle getParsedExpr() {
        return this.parsedExpr;
    }

    public synchronized void setParsedExpr(@Nullable Handle parsed, RhEngine engine) {
        if ((this.flags & 1) != 0) {
            return;
        }
        if (parsed == null) {
            this.flags |= 0x1000000;
        } else {
            engine.preserve(parsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(RhEngine engine) {
        ParsedExpr parsedExpr = this;
        synchronized (parsedExpr) {
            this.flags |= 1;
        }
        if (this.flags != 0 && this.parsedExpr != null) {
            engine.releasePreserved(this.parsedExpr);
            this.parsedExpr = null;
        }
    }
}

