/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv.engine;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.srv.RMIServerControl;
import org.eclipse.statet.rj.server.srv.engine.SrvEngine;
import org.eclipse.statet.rj.server.srvext.Client;

@NonNullByDefault
public class ComLoggingSrvEngine
implements SrvEngine {
    private final SrvEngine engine;
    private final Logger logger;

    public ComLoggingSrvEngine(SrvEngine engine, Logger logger) {
        this.engine = (SrvEngine)ObjectUtils.nonNullAssert((Object)engine);
        this.logger = (Logger)ObjectUtils.nonNullAssert((Object)logger);
    }

    @Override
    public void init(RMIServerControl control, Server publicServer, Map<String, ? extends @NonNull Object> more) throws Exception {
        this.engine.init(control, publicServer, more);
    }

    @Override
    public int[] getVersion() {
        return this.engine.getVersion();
    }

    @Override
    public int getState() {
        return this.engine.getState();
    }

    @Override
    public Client getCurrentClient() {
        return this.engine.getCurrentClient();
    }

    @Override
    public Map<String, Object> getPlatformData() {
        return this.engine.getPlatformData();
    }

    @Override
    public Object start(Client client, Map<String, ? extends @NonNull Object> properties) throws RemoteException {
        ComLogRecord ref = this.entering("start", client, properties);
        try {
            Object result = this.engine.start(client, properties);
            this.exiting(ref, result);
            return result;
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    @Override
    public Object connect(Client client, Map<String, ? extends @NonNull Object> properties) throws RemoteException {
        ComLogRecord ref = this.entering("connect", client, properties);
        try {
            Object result = this.engine.connect(client, properties);
            this.exiting(ref, result);
            return result;
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    @Override
    public void disconnect(Client client) throws RemoteException {
        ComLogRecord ref = this.entering("disconnect", client);
        try {
            this.engine.disconnect(client);
            this.exiting(ref);
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    @Override
    public void setProperties(Client client, Map<String, ? extends @NonNull Object> properties) throws RemoteException {
        ComLogRecord ref = this.entering("setProperties", client, properties);
        try {
            this.engine.setProperties(client, properties);
            this.exiting(ref);
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    @Override
    public RjsComObject runMainLoop(Client client, RjsComObject com) throws RemoteException {
        ComLogRecord ref = this.entering("runMainLoop", client, com);
        try {
            RjsComObject result = this.engine.runMainLoop(client, com);
            this.exiting(ref, result);
            return result;
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    @Override
    public RjsComObject runAsync(Client client, RjsComObject com) throws RemoteException {
        ComLogRecord ref = this.entering("runAsync", client, com);
        try {
            RjsComObject result = this.engine.runAsync(client, com);
            this.exiting(ref, result);
            return result;
        }
        catch (RuntimeException | RemoteException e) {
            this.exiting(ref, e);
            throw e;
        }
    }

    private ComLogRecord entering(String methodName, Client client, Object param0) {
        ComLogRecord record = new ComLogRecord(Level.FINER, methodName, client);
        ObjectUtils.ToStringBuilder sb = record.entering(null);
        sb.addProp(">>", param0);
        record.setMessage(sb.toString());
        this.logger.log(record);
        return record;
    }

    private ComLogRecord entering(String methodName, Client client) {
        ComLogRecord record = new ComLogRecord(Level.FINER, methodName, client);
        ObjectUtils.ToStringBuilder sb = record.entering(null);
        record.setMessage(sb.toString());
        this.logger.log(record);
        return record;
    }

    private void exiting(ComLogRecord ref, Object result) {
        ComLogRecord record = new ComLogRecord(Level.FINER, ref);
        ObjectUtils.ToStringBuilder sb = record.exiting(null);
        sb.addProp("<<", result);
        record.setMessage(sb.toString());
        this.logger.log(record);
    }

    private void exiting(ComLogRecord ref) {
        ComLogRecord record = new ComLogRecord(Level.FINER, ref);
        ObjectUtils.ToStringBuilder sb = record.exiting(null);
        record.setMessage(sb.toString());
        this.logger.log(record);
    }

    private void exiting(ComLogRecord ref, Throwable e) {
        ComLogRecord record = new ComLogRecord(Level.FINER, ref);
        ObjectUtils.ToStringBuilder sb = record.exiting("with exception");
        record.setMessage(sb.toString());
        record.setThrown(e);
        this.logger.log(record);
    }

    private static class ComLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 1L;
        private final transient Client client;
        private final long callId;

        public ComLogRecord(Level level, String methodName, Client client) {
            super(level, null);
            this.client = client;
            this.callId = this.getSequenceNumber();
            this.setSourceClassName("SrvEngine");
            this.setSourceMethodName(methodName);
        }

        public ComLogRecord(Level level, ComLogRecord ref) {
            super(level, null);
            this.client = ref.client;
            this.callId = ref.callId;
            this.setSourceClassName("SrvEngine");
            this.setSourceMethodName(ref.getSourceMethodName());
        }

        public ObjectUtils.ToStringBuilder entering(@Nullable String detail) {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("ENTRY #");
            sb.append(this.callId);
            if (detail != null) {
                sb.append(' ', detail);
            }
            sb.addProp("client", (Object)this.client);
            return sb;
        }

        public ObjectUtils.ToStringBuilder exiting(@Nullable String detail) {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("EXIT #");
            sb.append(this.callId);
            if (detail != null) {
                sb.append(' ', detail);
            }
            sb.addProp("client", (Object)this.client);
            return sb;
        }
    }
}

