/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.swt.painters;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.top.OverlayPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class TableLayerPainter
implements LayerPainter {
    private final NatTable natTable;

    public TableLayerPainter(NatTable natTable) {
        this.natTable = natTable;
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle cellBounds) {
        LayerPainter layerPainter = this.natTable.getUnderlyingLayer().getLayerPainter();
        return layerPainter.adjustCellBounds(columnPosition, rowPosition, cellBounds);
    }

    @Override
    public void paintLayer(Layer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, ConfigRegistry configRegistry) {
        try {
            this.paintBackground(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
            gc.setForeground(this.natTable.getForeground());
            Rectangle paintRectangle = pixelRectangle.intersection(SwtUtils.toSWT(new LRectangle(xOffset, yOffset, natLayer.getWidth(), natLayer.getHeight())));
            if (!paintRectangle.isEmpty()) {
                LayerPainter layerPainter = this.natTable.getUnderlyingLayer().getLayerPainter();
                layerPainter.paintLayer(natLayer, gc, xOffset, yOffset, paintRectangle, configRegistry);
            }
            this.paintOverlays(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "An error occurred while painting the table.", (Throwable)e));
        }
    }

    protected void paintBackground(Layer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, ConfigRegistry configRegistry) {
        gc.setBackground(this.natTable.getBackground());
        gc.fillRectangle(rectangle);
    }

    protected void paintOverlays(Layer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, ConfigRegistry configRegistry) {
        for (OverlayPainter overlayPainter : this.natTable.getOverlayPainters()) {
            overlayPainter.paintOverlay(gc, this.natTable);
        }
    }
}

