/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public enum ByteOrderMark {
    UTF_8(IOUtils.UTF_8_BOM){

        @Override
        public Charset getCharset() {
            return StandardCharsets.UTF_8;
        }
    }
    ,
    UTF_16BE(IOUtils.UTF_16BE_BOM){

        @Override
        public Charset getCharset() {
            return StandardCharsets.UTF_16BE;
        }
    }
    ,
    UTF_16LE(IOUtils.UTF_16LE_BOM){

        @Override
        public Charset getCharset() {
            return StandardCharsets.UTF_16LE;
        }
    };

    private final byte[] bytes;

    private ByteOrderMark(byte[] bytes) {
        this.bytes = bytes;
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.bytes.length;
    }

    public abstract Charset getCharset();

    public static @Nullable ByteOrderMark of(byte[] bom) {
        return switch (bom.length) {
            case 2 -> {
                switch (bom[0]) {
                    case -2: {
                        if (bom[1] == -1) {
                            yield UTF_16BE;
                        }
                        yield null;
                    }
                    case -1: {
                        if (bom[1] == -2) {
                            yield UTF_16LE;
                        }
                        yield null;
                    }
                }
                yield null;
            }
            case 3 -> {
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    yield UTF_8;
                }
                yield null;
            }
            default -> null;
        };
    }

    public static @Nullable ByteOrderMark read(InputStream in) throws IOException {
        return switch (in.read()) {
            case 239 -> {
                if (in.read() == 187 && in.read() == 191) {
                    yield UTF_8;
                }
                yield null;
            }
            case 254 -> {
                if (in.read() == 255) {
                    yield UTF_16BE;
                }
                yield null;
            }
            case 255 -> {
                if (in.read() == 254) {
                    yield UTF_16LE;
                }
                yield null;
            }
            default -> null;
        };
    }
}

