/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.CallArg;
import org.eclipse.statet.r.core.source.ast.CallArgs;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Placeholder;
import org.eclipse.statet.r.core.source.ast.PlaceholderDetail;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
final class RParserPostExprVisitor
extends RAstVisitor {
    private static final int ERROR_MASK = 0x4400000;
    private static final int WARNING_MASK = 0x2200000;
    private final RParser parser;
    private int severityInChild;

    public static void updateParentStatus(RAstNode node) {
        RAstNode rParent = node.rParent;
        if (rParent == null || (rParent.getStatusCode() & 0x4000000) != 0) {
            return;
        }
        int statusCode = node.getStatusCode();
        if ((statusCode & 0x4400000) != 0) {
            rParent.setStatusSeverityInChild(0x4000000);
        } else if ((statusCode & 0x2200000) != 0) {
            rParent.setStatusSeverityInChild(0x2000000);
        }
    }

    public RParserPostExprVisitor(RParser parser) {
        this.parser = parser;
    }

    public int check(RAstNode node) {
        this.severityInChild = 0;
        try {
            node.acceptInR(this);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return this.severityInChild;
    }

    private void updateSeverityInChild(RAstNode node) {
        if (this.severityInChild == 0x4000000) {
            return;
        }
        int statusCode = node.getStatusCode();
        if ((statusCode & 0x4400000) != 0) {
            this.severityInChild = 0x4000000;
        } else if ((statusCode & 0x2200000) != 0) {
            this.severityInChild = 0x2000000;
        }
    }

    private void doAcceptIn(RAstNode child) throws InvocationTargetException {
        int savedSeverity = this.severityInChild;
        this.severityInChild = 0;
        child.acceptInR(this);
        int severityInChild = this.severityInChild;
        if (severityInChild != 0) {
            child.rParent.setStatusSeverityInChild(severityInChild);
            this.severityInChild = Math.max(savedSeverity, severityInChild);
        } else {
            this.severityInChild = savedSeverity;
        }
    }

    private void doAccecptInChildren(RAstNode node) throws InvocationTargetException {
        int savedSeverity = this.severityInChild;
        this.severityInChild = 0;
        node.acceptInRChildren(this);
        int severityInChild = this.severityInChild;
        if (severityInChild != 0) {
            node.setStatusSeverityInChild(severityInChild);
            this.severityInChild = Math.max(savedSeverity, severityInChild);
        } else {
            this.severityInChild = savedSeverity;
        }
    }

    private void markSubsequentIfStatus12(RAstNode node, int statusCode) {
        if ((node.getStatusCode() & 0x7FFFF0) == statusCode) {
            node.setStatusSubsequent();
        }
    }

    @Override
    public void visit(SourceComponent node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Block node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Group node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        if (node.withElse) {
            this.doAcceptIn(node.elseExpr.node);
        }
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        this.doAcceptIn(node.refExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Pipe node) throws InvocationTargetException {
        RAstNode subRef;
        RAstNode target = node.getTargetChild();
        boolean isTargetValid = false;
        CallArgs callArgs = switch (target.getNodeType()) {
            case NodeType.F_CALL -> {
                isTargetValid = true;
                subRef = null;
                yield ((FCall)target).getArgsChild();
            }
            case NodeType.SUB_INDEXED_S, NodeType.SUB_INDEXED_D -> {
                subRef = ((SubIndexed)target).getRefChild();
                yield ((SubIndexed)target).getArgsChild();
            }
            case NodeType.SUB_NAMED_PART, NodeType.SUB_NAMED_SLOT -> {
                subRef = ((SubNamed)target).getRefChild();
                yield null;
            }
            default -> {
                subRef = null;
                yield null;
            }
        };
        Placeholder placeholder0 = null;
        if (subRef != null && subRef.getNodeType() == NodeType.PLACEHOLDER && subRef.getOperator(0) == RTerminal.PIPE_PLACEHOLDER) {
            if (this.parser.getLangVersion() >= 3) {
                isTargetValid = true;
                placeholder0 = (Placeholder)subRef;
                subRef.setStatus(0);
            } else if (this.parser.getLangVersion() < 1) {
                isTargetValid = true;
                this.markSubsequentIfStatus12(subRef, 4228880);
            }
        }
        if (callArgs != null) {
            if (this.parser.getLangVersion() >= 2) {
                for (CallArg callArg : callArgs.getArgChildren()) {
                    RAstNode argValue = callArg.getValueChild();
                    if (argValue == null || argValue.getNodeType() != NodeType.PLACEHOLDER || argValue.getOperator(0) != RTerminal.PIPE_PLACEHOLDER) continue;
                    if (placeholder0 != null) {
                        argValue.setStatus(4227490);
                        continue;
                    }
                    placeholder0 = (Placeholder)argValue;
                    isTargetValid = true;
                    if (!callArg.hasName()) {
                        argValue.setStatus(4227491);
                        continue;
                    }
                    argValue.setStatus(0);
                    callArg.clearStatusSeverityInChild();
                    RParserPostExprVisitor.updateParentStatus(callArg.getNameChild());
                }
                if (placeholder0 != null) {
                    callArgs.clearStatusSeverityInChild();
                    for (CallArg callArg : callArgs.getArgChildren()) {
                        RParserPostExprVisitor.updateParentStatus(callArg);
                    }
                    target.clearStatusSeverityInChild();
                    RParserPostExprVisitor.updateParentStatus(callArgs);
                }
            } else if (this.parser.getLangVersion() < 1) {
                for (CallArg callArg : callArgs.getArgChildren()) {
                    RAstNode argValue = callArg.getValueChild();
                    if (argValue == null || argValue.getNodeType() != NodeType.PLACEHOLDER || argValue.getOperator(0) != RTerminal.PIPE_PLACEHOLDER) continue;
                    this.markSubsequentIfStatus12(argValue, 4228880);
                }
            }
        }
        if (this.parser.getLangVersion() >= 1) {
            if (!isTargetValid && (target.getStatusCode() & 0x7FFFF0) != 4228016) {
                target.setStatusThis(4227504);
            }
        } else {
            this.markSubsequentIfStatus12(node.getSourceChild(), 4227858);
            this.markSubsequentIfStatus12(target, 4228016);
            this.markSubsequentIfStatus12(target, 4227504);
        }
        if ((this.parser.getAstLevel() & 0xF) >= 4 && placeholder0 != null) {
            placeholder0.addAttachment(new PlaceholderDetail(placeholder0, node.getSourceChild()));
        }
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Symbol node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Placeholder node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(StringConst node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(NumberConst node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }
}

