/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.extensions.core.IPointSeriesSettings;
import org.eclipse.swtchart.extensions.dialogs.AbstractSeriesSettingsDialog;

public abstract class AbstractPointSeriesSettingsDialog<T extends IPointSeriesSettings>
extends AbstractSeriesSettingsDialog<T> {
    private AtomicReference<ComboViewer> symbolTypeControl = new AtomicReference();
    private AtomicReference<Spinner> symbolSizeControl = new AtomicReference();
    private AtomicReference<Text> symbolColorControl = new AtomicReference();

    public AbstractPointSeriesSettingsDialog(Shell parentShell, T settings) {
        super(parentShell, settings);
    }

    @Override
    protected void createInputSection(Composite parent) {
        super.createInputSection(parent);
        this.createSymbolTypeSection(parent);
        this.createSymbolSizeSection(parent);
        this.createSymbolColorSection(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        IPointSeriesSettings settings = (IPointSeriesSettings)this.getSettings();
        if (settings != null) {
            this.symbolTypeControl.get().setSelection((ISelection)new StructuredSelection((Object)settings.getSymbolType()));
            this.symbolSizeControl.get().setSelection(settings.getSymbolSize());
            this.symbolColorControl.get().setBackground(settings.getSymbolColor());
        }
    }

    private void createSymbolTypeSection(Composite parent) {
        String title = "Symbol Type";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, (IEnumLabel[])ILineSeries.PlotSymbolType.values(), ILineSeries.PlotSymbolType.NONE, this.getGridData(768, 2), object -> {
            IPointSeriesSettings settings = (IPointSeriesSettings)this.getSettings();
            if (settings != null && object instanceof ILineSeries.PlotSymbolType) {
                settings.setSymbolType((ILineSeries.PlotSymbolType)object);
            }
        });
        this.symbolTypeControl.set(comboViewer);
    }

    private void createSymbolSizeSection(Composite parent) {
        String title = "Symbol Size";
        this.createSectionLabel(parent, title);
        Spinner spinner = this.createSpinner(parent, title, 1, 50, 1, this.getGridData(768, 2), selection -> {
            IPointSeriesSettings settings = (IPointSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setSymbolSize((int)selection);
            }
        });
        this.symbolSizeControl.set(spinner);
    }

    private void createSymbolColorSection(Composite parent) {
        String title = "Symbol Color";
        this.createSectionLabel(parent, title);
        Text text = this.createColorChoser(parent, title, this.getGridData(768, 1), color -> {
            IPointSeriesSettings settings = (IPointSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setSymbolColor((Color)color);
            }
        });
        this.symbolColorControl.set(text);
    }
}

