/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.core;

import org.eclipse.swtchart.vectorgraphics2d.core.Processor;
import org.eclipse.swtchart.vectorgraphics2d.eps.EPSProcessor;
import org.eclipse.swtchart.vectorgraphics2d.pdf.PDFProcessor;
import org.eclipse.swtchart.vectorgraphics2d.svg.SVGProcessor;

public abstract class Processors {
    Processors() {
        throw new UnsupportedOperationException();
    }

    public static Processor get(String format) {
        if (format == null) {
            throw new NullPointerException("Format cannot be null.");
        }
        switch (format) {
            case "eps": {
                return new EPSProcessor();
            }
            case "pdf": {
                return new PDFProcessor(true);
            }
            case "svg": {
                return new SVGProcessor();
            }
        }
        throw new IllegalArgumentException("Unknown format \"" + format + "\"");
    }
}

