/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui;

import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.model.iface.TaskingElement;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.ui.Activator;
import org.eclipse.tea.core.ui.TaskingModelTreePanel;
import org.eclipse.tea.core.ui.internal.run.RunTaskChain;

@Creatable
public class SelectTaskChainDialog
extends TitleAreaDialog {
    private TaskChain selectedChain;
    private final TaskingModel model;
    private TaskingModelTreePanel root;

    @Inject
    public SelectTaskChainDialog(TaskingModel model) {
        super(null);
        this.setBlockOnOpen(true);
        this.model = model;
    }

    protected Point getInitialSize() {
        return new Point(550, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Execute TaskChain");
        this.setMessage("Select Task Chain to execute...");
        this.setTitleImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui", (String)"resources/tea-full60.png").createImage());
        this.root = new TaskingModelTreePanel(parent, this.model);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.root);
        this.root.addSelectionListener(e -> {
            TaskingElement o = this.root.getSelection();
            if (o instanceof TaskingItem) {
                this.getButton(0).setEnabled(((TaskingItem)o).getChain().getClass() != RunTaskChain.class);
            } else {
                this.getButton(0).setEnabled(false);
            }
        });
        return this.root;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.selectedChain = ((TaskingItem)this.root.getSelection()).getChain();
        super.okPressed();
    }

    public TaskChain getSelectedChain() {
        return this.selectedChain;
    }
}

