/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parsers;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.python.internal.core.parsers.DLTKTokenConverter;
import org.eclipse.dltk.python.internal.core.parsers.python_v3Parser;

public class DLTKPythonErrorReporter {
    IProblemReporter reporter;
    DLTKTokenConverter converter;
    python_v3Parser parser;
    List problems = new ArrayList();

    public DLTKPythonErrorReporter(DLTKTokenConverter converter, IProblemReporter reporter, python_v3Parser parser) {
        this.converter = converter;
        this.reporter = reporter;
        this.parser = parser;
    }

    public void reportError(RecognitionException re) {
        block13: {
            if (this.reporter == null) {
                return;
            }
            try {
                String message = re.getMessage();
                if (re instanceof NoViableAltException) {
                    NoViableAltException ec = (NoViableAltException)re;
                    String[] messages = new String[]{"Syntax Error:" + message, ec.token.getText()};
                    int st = this.converter.convert(ec.token).getColumn() - 1;
                    String sm = ec.token.getText();
                    int et = st + (sm != null ? sm.length() : 1);
                    if (st == -1) {
                        return;
                    }
                    DefaultProblem defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], 1, st, et, ec.token.getLine());
                    if (!this.problems.contains(defaultProblem)) {
                        this.reporter.reportProblem((IProblem)defaultProblem);
                        this.problems.add(defaultProblem);
                    }
                } else if (re instanceof MismatchedTokenException) {
                    DefaultProblem defaultProblem;
                    String sm;
                    MismatchedTokenException ec = (MismatchedTokenException)re;
                    if (message == null) {
                        message = "mismatched input " + this.parser.getTokenErrorDisplay(ec.token);
                    }
                    String[] messages = new String[]{"Syntax Error:" + message, message, ec.token.getText()};
                    int st = this.converter.convert(ec.token).getColumn() - 1;
                    int et = st + ((sm = ec.token.getText()) != null ? sm.length() : 1);
                    if (et >= this.converter.length()) {
                        et = this.converter.length() - 1;
                        st -= 2;
                    }
                    if (!this.problems.contains(defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], 1, st, et, ec.line))) {
                        this.reporter.reportProblem((IProblem)defaultProblem);
                        this.problems.add(defaultProblem);
                    }
                } else {
                    int et;
                    int st;
                    String[] messages = new String[]{"Syntax Error:" + message, message};
                    DefaultProblem defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], 1, st = this.converter.convert(re.token).getColumn(), et = st + 1, re.token.getLine());
                    if (!this.problems.contains(defaultProblem)) {
                        this.reporter.reportProblem((IProblem)defaultProblem);
                        this.problems.add(defaultProblem);
                    }
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block13;
                e.printStackTrace();
            }
        }
    }

    public void reportThrowable(Throwable extre) {
        extre.printStackTrace();
    }

    public void reportMessage(String msg) {
        System.err.println("PythonParser:" + msg);
    }
}

