/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.folding;

import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FakeModuleDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.text.IRubyPartitions;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RubyFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private boolean fInitCollapseComments;
    private boolean fInitCollapseHeaderComments;
    private boolean fInitCollapseMethods;

    protected void initializePreferences(IPreferenceStore store) {
        super.initializePreferences(store);
        this.fFoldNewLines = true;
        this.fCommentsFolding = true;
        this.fInitCollapseComments = store.getBoolean("editor_folding_init_comments");
        this.fInitCollapseHeaderComments = store.getBoolean("editor_folding_init_header_comments");
        this.fInitCollapseMethods = store.getBoolean("editor_folding_init_methods");
    }

    protected boolean initiallyCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return ctx.allowCollapsing() && s instanceof MethodDeclaration && this.fInitCollapseMethods;
    }

    protected boolean initiallyCollapseComments(IRegion commentRegion, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (ctx.allowCollapsing()) {
            return this.isHeaderRegion(commentRegion, ctx) ? this.fInitCollapseHeaderComments : this.fInitCollapseComments;
        }
        return false;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return s instanceof MethodDeclaration;
    }

    protected String getCommentPartition() {
        return "__ruby_comment";
    }

    protected String getPartition() {
        return "__ruby_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new RubyPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return IRubyPartitions.RUBY_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    protected ILog getLog() {
        return RubyUI.getDefault().getLog();
    }

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ISourceParser parser = this.getSourceParser();
        ModuleDeclaration decl = parser.parse(null, code.toCharArray(), null);
        if (decl instanceof FakeModuleDeclaration) {
            return null;
        }
        return this.buildCodeBlocks(decl, offset);
    }
}

