/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;

public class RubyMixinAlias
implements IRubyMixinElement {
    private final IMixinElement element;
    private final RubyMixinModel model;
    private final RubyAliasExpression alias;
    private final ISourceModule sourceModule;

    public RubyMixinAlias(RubyMixinModel model, String key) {
        this.model = model;
        this.element = model.getRawModel().get(key);
        Assert.isNotNull((Object)this.element);
        ISourceModule[] sourceModules = this.element.getSourceModules();
        ISourceModule sourceModule2 = null;
        RubyAliasExpression alias2 = null;
        int j = 0;
        while (j < sourceModules.length) {
            ISourceModule module = sourceModules[j];
            Object[] objects = this.element.getObjects(module);
            int i = 0;
            while (i < objects.length) {
                RubyMixinElementInfo info = (RubyMixinElementInfo)objects[i];
                if (info.getKind() == 7) {
                    alias2 = (RubyAliasExpression)((Object)info.getObject());
                    sourceModule2 = module;
                    break;
                }
                ++i;
            }
            ++j;
        }
        this.alias = alias2;
        this.sourceModule = sourceModule2;
        Assert.isNotNull((Object)((Object)this.alias));
    }

    public String getOldKey() {
        String old = this.alias.getOldValue();
        return String.valueOf(this.element.getParent().getKey()) + "{" + old;
    }

    public IRubyMixinElement getOldElement() {
        return this.model.createRubyElement(this.getOldKey());
    }

    public String getKey() {
        return this.element.getKey();
    }

    public String getNewName() {
        return this.alias.getNewValue();
    }

    public RubyAliasExpression getAlias() {
        return this.alias;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }
}

