/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyMethodReference;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.MethodCallVerificationGoal;
import org.eclipse.dltk.ti.goals.PossiblePosition;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class MethodCallVerificator
extends GoalEvaluator {
    private static final int INIT = 0;
    private static final int RECEIVER_WAIT = 1;
    private int state = 0;
    private RubyMethodReference result = null;
    private IEvaluatedType receiverType;
    private PossiblePosition position;
    private boolean topLevelMethod;

    public MethodCallVerificator(IGoal goal) {
        super(goal);
    }

    private MethodCallVerificationGoal getTypedGoal() {
        return (MethodCallVerificationGoal)this.getGoal();
    }

    public IGoal[] init() {
        this.topLevelMethod = false;
        MethodCallVerificationGoal goal2 = this.getTypedGoal();
        this.position = goal2.getPosition();
        IResource resource = this.position.getResource();
        IModelElement element = DLTKCore.create((IResource)resource);
        if (element instanceof ISourceModule) {
            ModuleDeclaration decl = ASTUtils.getAST((ISourceModule)element);
            ASTNode node = this.position.getNode();
            if (node == null) {
                node = ASTUtils.findMinimalNode(decl, this.position.getOffset(), this.position.getOffset() + this.position.getLength() - 1);
            }
            if (node instanceof CallExpression) {
                this.receiverType = null;
                CallExpression call = (CallExpression)node;
                ASTNode receiver = call.getReceiver();
                if (receiver != null) {
                    ExpressionTypeGoal rgoal = new ExpressionTypeGoal((IContext)new BasicContext((ISourceModule)element, decl), receiver);
                    this.state = 1;
                    return new IGoal[]{rgoal};
                }
                this.receiverType = RubyTypeInferencingUtils.determineSelfClass((ISourceModule)element, decl, node.sourceStart());
            }
        }
        return null;
    }

    public Object produceResult() {
        String key;
        if (!(this.receiverType instanceof RubyClassType)) {
            return null;
        }
        MethodCallVerificationGoal goal2 = this.getTypedGoal();
        RubyClassType type = (RubyClassType)this.receiverType;
        String parentModelKey = goal2.getGoal().getParentModelKey();
        String name = goal2.getGoal().getName();
        String requiredKey = String.valueOf(parentModelKey != null ? String.valueOf(parentModelKey) + "{" : "") + name;
        RubyMixinClass rclass = RubyMixinModel.getInstance().createRubyClass(type);
        RubyMixinMethod method = null;
        if (this.topLevelMethod) {
            method = (RubyMixinMethod)RubyMixinModel.getInstance().createRubyElement(name);
        } else if (rclass != null) {
            method = rclass.getMethod(name);
        }
        if (method != null && ((key = method.getKey()).equals(requiredKey) || parentModelKey.equals("Object") && key.equals(name))) {
            this.result = new RubyMethodReference(name, parentModelKey, this.position, 0);
            if (this.position.getNode() instanceof CallExpression) {
                this.result.setNode((CallExpression)this.position.getNode());
            }
        }
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (this.state == 1) {
            this.receiverType = (IEvaluatedType)result;
        }
        return null;
    }
}

