/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.dbgp.IDbgpFeature;
import org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;
import org.eclipse.dltk.tcl.activestatedebugger.ActiveStateInstrumentCommands;
import org.eclipse.dltk.tcl.activestatedebugger.ErrorAction;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationFeature;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationSetup;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationUtils;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationConfig;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationMode;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ModelElementPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.Pattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PatternListIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclActiveStateDebugThreadConfigurator
implements IScriptDebugThreadConfigurator {
    private boolean initialized = false;
    private final IScriptProject project;
    private final IPreferencesLookupDelegate delegate;

    public TclActiveStateDebugThreadConfigurator(IScriptProject project, IPreferencesLookupDelegate delegate) {
        this.project = project;
        this.delegate = delegate;
    }

    public void configureThread(DbgpDebugger engine, ScriptThread scriptThread) {
        block4: {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            try {
                IDbgpFeature tclFeature = engine.getFeature("tcl_instrument_set");
                if (tclFeature.isSupported()) {
                    ActiveStateInstrumentCommands commands = new ActiveStateInstrumentCommands(engine.getSession().getCommunicator());
                    this.initializeDebugger(commands);
                }
            }
            catch (DbgpException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    private static List<PatternRef> parsePatterns(InstrumentationConfig config) {
        ArrayList<PatternRef> result = new ArrayList<PatternRef>();
        if (config != null) {
            for (Pattern pattern : config.getModelElements()) {
                if (pattern instanceof ModelElementPattern) {
                    IModelElement element = DLTKCore.create((String)((ModelElementPattern)pattern).getHandleIdentifier());
                    if (element == null) continue;
                    result.add(new ModelElementRef(element, pattern.isInclude()));
                    continue;
                }
                if (!(pattern instanceof LibraryPattern)) continue;
                result.add(new LibraryContainerRef(pattern.isInclude()));
            }
        }
        return result;
    }

    private void initializeDebugger(ActiveStateInstrumentCommands commands) throws DbgpException {
        InstrumentationConfig config;
        InstrumentationMode mode;
        Set<InstrumentationFeature> selectedFeatures = InstrumentationFeature.decode(this.getString("instrumentationFeatures"));
        InstrumentationFeature[] instrumentationFeatureArray = InstrumentationFeature.values();
        int n = instrumentationFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            InstrumentationFeature feature = instrumentationFeatureArray[n2];
            commands.instrumentSet(feature, selectedFeatures.contains((Object)feature));
            ++n2;
        }
        ErrorAction errorAction = ErrorAction.decode(this.getString("instrumentationErrorAction"));
        if (errorAction != null) {
            commands.setErrorAction(errorAction);
        }
        if ((mode = InstrumentationUtils.getMode(config = PatternListIO.decode(this.getString("instrumentationPatterns")))) == InstrumentationMode.DEFAULT) {
            return;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.project);
        if (environment == null) {
            return;
        }
        InstrumentationSetup configurator = new InstrumentationSetup(environment);
        InstrumentationContentProvider provider = new InstrumentationContentProvider();
        HashSet<IModelElement> processed = new HashSet<IModelElement>();
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        InstrumentationUtils.collectProjects(projects, this.project);
        boolean libraryInclude = false;
        if (mode == InstrumentationMode.SOURCES) {
            for (IScriptProject project : projects) {
                TclActiveStateDebugThreadConfigurator.collect(provider, processed, (IModelElement)project);
                configurator.addProject(project, true);
            }
        } else {
            for (PatternRef pattern : TclActiveStateDebugThreadConfigurator.parsePatterns(config)) {
                if (pattern instanceof ModelElementRef) {
                    IModelElement element = ((ModelElementRef)pattern).element;
                    TclActiveStateDebugThreadConfigurator.collect(provider, processed, element);
                    if (element instanceof ISourceModule) {
                        configurator.addSourceModule((ISourceModule)element, pattern.include);
                        continue;
                    }
                    if (element instanceof IScriptFolder) {
                        configurator.addScriptFolder((IScriptFolder)element, pattern.include);
                        continue;
                    }
                    if (element instanceof IProjectFragment) {
                        IProjectFragment fragment = (IProjectFragment)element;
                        configurator.addProjectFragment(fragment, pattern.include);
                        continue;
                    }
                    if (!(element instanceof IScriptProject)) continue;
                    configurator.addProject((IScriptProject)element, pattern.include);
                    continue;
                }
                if (!(pattern instanceof LibraryContainerRef)) continue;
                libraryInclude = pattern.include;
            }
            for (IScriptProject project : projects) {
                if (!processed.add((IModelElement)project)) continue;
                configurator.addProject(project, false);
            }
        }
        for (IProjectFragment fragment : InstrumentationUtils.collectExternalFragments(projects)) {
            if (!processed.add((IModelElement)fragment)) continue;
            configurator.addProjectFragment(fragment, libraryInclude);
        }
        configurator.send(commands);
    }

    private static void collect(InstrumentationContentProvider provider, Set<IModelElement> processed, IModelElement element) {
        Object parent;
        if (processed.add(element) && (parent = provider.getParent(element)) != null && parent instanceof IModelElement) {
            TclActiveStateDebugThreadConfigurator.collect(provider, processed, (IModelElement)parent);
        }
    }

    private String getString(String key) {
        return this.delegate.getString("org.eclipse.dltk.tcl.activestatedebugger", key);
    }

    private List<IMarker> loadSpawnpoints() throws CoreException {
        IWorkspaceRoot root = InstrumentationUtils.getWorkspaceRoot();
        IMarker[] markers = root.findMarkers("org.eclipse.dltk.tcl.activestatedebugger.spawnpoint", true, 2);
        if (markers.length == 0) {
            return Collections.emptyList();
        }
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.project);
        if (environment == null) {
            return Arrays.asList(markers);
        }
        HashMap<IProject, Boolean> projectStatus = new HashMap<IProject, Boolean>();
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IProject project = marker.getResource().getProject();
            Boolean status = (Boolean)projectStatus.get(project);
            if (status == null) {
                status = environment.equals(EnvironmentManager.getEnvironment((IProject)project)) ? Boolean.TRUE : Boolean.FALSE;
                projectStatus.put(project, status);
            }
            if (status.booleanValue()) {
                result.add(marker);
            }
            ++n2;
        }
        return result;
    }

    public void initializeBreakpoints(IScriptThread thread, IProgressMonitor monitor) {
        try {
            List<IMarker> spawnpoints = this.loadSpawnpoints();
            monitor.beginTask("", spawnpoints.size());
            IDbgpSpawnpointCommands commands = (IDbgpSpawnpointCommands)thread.getDbgpSession().get(IDbgpSpawnpointCommands.class);
            IScriptBreakpointPathMapper pathMapper = ((IScriptDebugTarget)thread.getDebugTarget()).getPathMapper();
            for (IMarker spawnpoint : spawnpoints) {
                URI uri = ScriptLineBreakpoint.makeUri((IPath)new Path(spawnpoint.getResource().getLocationURI().getPath()));
                try {
                    int lineNumber = spawnpoint.getAttribute("lineNumber", 0) + 1;
                    commands.setSpawnpoint(pathMapper.map(uri), lineNumber, true);
                }
                catch (DbgpException e) {
                    TclActiveStateDebuggerPlugin.warn(e);
                }
                monitor.worked(1);
            }
        }
        catch (CoreException e) {
            TclActiveStateDebuggerPlugin.warn(e);
        }
        monitor.done();
    }

    private static class LibraryContainerRef
    extends PatternRef {
        public LibraryContainerRef(boolean include) {
            super(include);
        }
    }

    private static class ModelElementRef
    extends PatternRef {
        final IModelElement element;

        public ModelElementRef(IModelElement element, boolean include) {
            super(include);
            this.element = element;
        }
    }

    private static abstract class PatternRef {
        final boolean include;

        public PatternRef(boolean include) {
            this.include = include;
        }
    }
}

