/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search.mixin;

import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.core.extensions.IMixinBuildVisitorExtension;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclField;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclNamespace;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclNamespaceImport;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclPackage;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclProc;

public class TclMixinBuildVisitor
extends ASTVisitor {
    protected boolean signature = false;
    protected ISourceModule sourceModule;
    protected ModuleDeclaration moduleDeclaration;
    protected IMixinRequestor requestor;
    protected Stack namespaceNames = new Stack();
    protected IMixinBuildVisitorExtension[] extensions;

    public TclMixinBuildVisitor(ModuleDeclaration moduleDeclaration, ISourceModule module, boolean signature, IMixinRequestor requestor) {
        this.signature = signature;
        this.sourceModule = module;
        this.moduleDeclaration = moduleDeclaration;
        this.requestor = requestor;
        this.extensions = TclExtensionManager.getDefault().getMixinVisitorExtensions();
    }

    public boolean endvisit(TypeDeclaration s) throws Exception {
        if (s.getName().indexOf(91) != -1 || s.getName().indexOf(36) != -1) {
            return true;
        }
        this.namespaceNames.pop();
        return true;
    }

    public String getKeyFromLevels(List nodes) {
        return TclParseUtil.getElementFQN(nodes, IMixinRequestor.MIXIN_NAME_SEPARATOR, this.moduleDeclaration);
    }

    public String getNamespacePrefix() {
        StringBuffer prefix = new StringBuffer();
        for (TypeDeclaration ns : this.namespaceNames) {
            String name = ns.getName();
            if (name.endsWith("::")) {
                name = name.substring(0, name.length() - 2);
            }
            if (name.startsWith("::")) {
                prefix.setLength(0);
                name = name.substring(2);
            }
            prefix.append(String.valueOf(this.tclNameToKey(name)) + IMixinRequestor.MIXIN_NAME_SEPARATOR);
        }
        return prefix.toString();
    }

    public String getRealNamespacePrefix() {
        StringBuffer prefix = new StringBuffer();
        for (TypeDeclaration ns : this.namespaceNames) {
            String name = ns.getName();
            if (name.endsWith("::")) {
                name = name.substring(0, name.length() - 2);
            }
            if (name.startsWith("::")) {
                prefix.setLength(0);
                name = name.substring(2);
            }
            prefix.append(String.valueOf(name) + "::");
        }
        String result = prefix.toString();
        if (result.startsWith("::")) {
            result = result.substring(2);
        }
        if (result.endsWith("::")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public String tclNameToKey(String name) {
        return TclParseUtil.tclNameTo(name, IMixinRequestor.MIXIN_NAME_SEPARATOR);
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].visit(s, this)) {
                return true;
            }
            ++i;
        }
        IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
        String name = s.getName();
        if (name.startsWith("::")) {
            info.key = this.tclNameToKey(name.substring(2));
        } else if (name.indexOf("::") == -1) {
            info.key = String.valueOf(this.getNamespacePrefix()) + this.tclNameToKey(name);
        } else {
            TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom(this.moduleDeclaration, (ASTNode)s);
            if (type != null) {
                List levels = TclParseUtil.findLevelsTo(this.moduleDeclaration, (ASTNode)type);
                String[] mName = TclParseUtil.tclSplit(name);
                info.key = String.valueOf(this.getKeyFromLevels(levels)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + mName[mName.length - 1];
            } else {
                info.key = this.tclNameToKey(name);
            }
        }
        if (info.key != null) {
            if (this.signature) {
                info.object = new TclProc();
            }
            this.requestor.reportElement(info);
        }
        return true;
    }

    public boolean visit(Statement s) throws Exception {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].visit(s, this)) {
                return false;
            }
            ++i;
        }
        this.processPackageStatements(s);
        if (s instanceof TclStatement) {
            this.processNamespaceImport(s);
        }
        if (s instanceof FieldDeclaration) {
            FieldDeclaration field = (FieldDeclaration)s;
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            if (!TclParseUtil.isArrayVariable(field.getName())) {
                List levels = TclParseUtil.findLevelsTo(this.moduleDeclaration, (ASTNode)s);
                info.key = String.valueOf(TclParseUtil.getElementFQN(levels, IMixinRequestor.MIXIN_NAME_SEPARATOR, this.moduleDeclaration)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + this.tclNameToKey(field.getName());
                if (info.key.startsWith("{")) {
                    info.key = info.key.substring(1);
                }
            } else {
                info.key = String.valueOf(this.getNamespacePrefix()) + this.tclNameToKey(TclParseUtil.extractArrayName(field.getName()));
            }
            if (this.signature) {
                info.object = new TclField();
            }
            this.requestor.reportElement(info);
        }
        return super.visit(s);
    }

    static boolean isValidPackageName(String packageName) {
        return packageName != null && packageName.length() != 0 && packageName.indexOf(36) == -1 && packageName.indexOf(91) == -1 && packageName.indexOf(93) == -1;
    }

    private void processPackageStatements(Statement s) {
        TclPackageDeclaration pkg;
        if (s instanceof TclPackageDeclaration && ((pkg = (TclPackageDeclaration)s).getStyle() == 1 || pkg.getStyle() == 0) && TclMixinBuildVisitor.isValidPackageName(pkg.getName())) {
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            String version = "";
            if (pkg.getVersion() != null && pkg.getVersion() instanceof SimpleReference) {
                version = ((SimpleReference)pkg.getVersion()).getName();
            }
            info.key = TclPackage.makeKey(pkg.getName(), version, "provide");
            if (info.key != null) {
                if (this.signature) {
                    info.object = new TclPackage(pkg.getName(), version, "provide");
                }
                this.requestor.reportElement(info);
            }
        }
    }

    private void processNamespaceImport(Statement s) {
        TclStatement st = (TclStatement)s;
        if (st.getCount() > 2) {
            String cmdValue = this.getValue(st.getAt(0));
            if (!"namespace".equals(cmdValue)) {
                return;
            }
            String arg0 = this.getValue(st.getAt(1));
            if (!"import".equals(arg0)) {
                return;
            }
            String currentNamespace = this.getRealNamespacePrefix();
            int i = 2;
            while (i < st.getCount()) {
                String value = this.getValue(st.getAt(i));
                if (value != null && !"-force".equals(value)) {
                    IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
                    value = TclNamespaceImport.processPattern(value);
                    info.key = TclNamespaceImport.makeKey(currentNamespace, value);
                    if (info.key != null) {
                        if (this.signature) {
                            info.object = new TclNamespaceImport(currentNamespace, value);
                        }
                        this.requestor.reportElement(info);
                    }
                }
                ++i;
            }
        }
    }

    private String getValue(Expression cmd) {
        if (cmd instanceof SimpleReference) {
            String cmdValue = ((SimpleReference)cmd).getName();
            if (cmdValue.startsWith("::")) {
                cmdValue = cmdValue.substring(2);
            }
            return cmdValue;
        }
        return null;
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        if (s.getName().indexOf(91) != -1 || s.getName().indexOf(36) != -1) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].visit(s, this)) {
                return true;
            }
            ++i;
        }
        IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
        info.key = String.valueOf(this.getNamespacePrefix()) + this.tclNameToKey(s.getName());
        if (info.key.startsWith("{")) {
            info.key = info.key.substring(1);
        }
        this.namespaceNames.push(s);
        if (this.signature) {
            info.object = new TclNamespace();
        }
        this.requestor.reportElement(info);
        return true;
    }

    public boolean getSignature() {
        return this.signature;
    }

    public IMixinRequestor getRequestor() {
        return this.requestor;
    }

    public ModuleDeclaration getModuleDeclaration() {
        return this.moduleDeclaration;
    }

    public void pushNamespaceName(TypeDeclaration s) {
        this.namespaceNames.push(s);
    }
}

