/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.packages;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptProjectUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.indexing.PackageSourceCollector;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.tcl.internal.validators.TclBuildContext;
import org.eclipse.dltk.tcl.internal.validators.packages.Messages;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.validators.TclValidatorsCore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageRequireSourceAnalyser
implements IBuildParticipant,
IBuildParticipantExtension,
IBuildParticipantExtension2 {
    private final IScriptProject project;
    private final IInterpreterInstall install;
    private final PackageSourceCollector packageCollector = new PackageSourceCollector();
    private final List<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private int buildType;
    private boolean autoAddPackages;
    private Set<TclModuleInfo> providedByRequiredProjects = new HashSet<TclModuleInfo>();
    private final NamespaceScopeProcessor processor = DefinitionManager.getInstance().createProcessor();
    private static final char[] PACKAGE_CHARS = "package".toCharArray();
    private List<TclPackageInfo> knownInfos;

    public PackageRequireSourceAnalyser(IScriptProject project) throws CoreException, IllegalStateException {
        this.project = project;
        this.install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        if (this.install == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.TclCheckBuilder_interpreterNotFound, (Object)project.getElementName()));
        }
        this.knownInfos = TclPackagesManager.getPackageInfos((IInterpreterInstall)this.install);
    }

    public boolean beginBuild(int buildType) {
        this.buildType = buildType;
        this.autoAddPackages = ScriptProjectUtil.isBuilderEnabled((IScriptProject)this.project);
        ArrayList moduleInfos = new ArrayList();
        moduleInfos.addAll(TclPackagesManager.getProjectModules((String)this.project.getElementName()));
        if (buildType == 1) {
            for (TclModuleInfo tclModuleInfo : moduleInfos) {
                tclModuleInfo.getProvided().clear();
                tclModuleInfo.getRequired().clear();
                tclModuleInfo.getSourced().clear();
            }
        }
        this.packageCollector.getModules().put(this.project, moduleInfos);
        this.loadProvidedPackagesFromRequiredProjects();
        return true;
    }

    private void loadProvidedPackagesFromRequiredProjects() {
        IBuildpathEntry[] resolvedBuildpath;
        try {
            resolvedBuildpath = this.project.getResolvedBuildpath(true);
        }
        catch (ModelException e) {
            TclValidatorsCore.error(e);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < resolvedBuildpath.length) {
            IPath path;
            IProject project;
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getEntryKind() == 2 && (project = workspaceRoot.getProject((path = entry.getPath()).lastSegment())).exists()) {
                List list = TclPackagesManager.getProjectModules((String)project.getName());
                this.providedByRequiredProjects.addAll(list);
            }
            ++i;
        }
    }

    public void buildExternalModule(IBuildContext context) throws CoreException {
        ISourceModule module = context.getSourceModule();
        if (module instanceof TclPackageSourceModule) {
            return;
        }
        TclModule tclModule = TclBuildContext.getStatements(context);
        EList statements = tclModule.getStatements();
        this.packageCollector.process((List)statements, module);
        this.addInfoForModule(context, module, null);
    }

    public void build(IBuildContext context) throws CoreException {
        ISourceModule module = context.getSourceModule();
        TclModule tclModule = TclBuildContext.getStatements(context);
        EList statements = tclModule.getStatements();
        if (statements == null) {
            return;
        }
        this.packageCollector.process((List)statements, module);
        this.addInfoForModule(context, module, null);
    }

    private void addInfoForModule(IBuildContext context, ISourceModule module, TclModuleInfo info) {
        IFileHandle file;
        URI uri;
        IPath modulePath = module.getPath();
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.project);
        if (module.getResource() != null && (modulePath = module.getResource().getLocation()) == null && (uri = module.getResource().getLocationURI()) != null && (file = env.getFile(uri)) != null) {
            modulePath = file.getPath();
        }
        TclModuleInfo mInfo = this.packageCollector.getCreateCurrentModuleInfo(module);
        if (info != null) {
            mInfo.getProvided().addAll((Collection)info.getProvided());
            mInfo.getRequired().addAll((Collection)info.getRequired());
            mInfo.getSourced().addAll((Collection)info.getSourced());
        }
        this.modules.add(new ModuleInfo(module.getElementName(), context.getLineTracker(), context.getProblemReporter(), mInfo, modulePath, module));
    }

    public void endBuild(IProgressMonitor monitor) {
        monitor.subTask(Messages.TclCheckBuilder_retrievePackages);
        HashSet<String> names = new HashSet<String>();
        HashSet<String> autoNames = new HashSet<String>();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)this.project, names, autoNames);
        HashSet<String> newDependencies = new HashSet<String>();
        int remainingWork = this.modules.size();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.project);
        for (ModuleInfo moduleInfo : this.modules) {
            monitor.subTask(NLS.bind((String)Messages.TclCheckBuilder_processing, (Object)moduleInfo.name, (Object)Integer.toString(remainingWork)));
            for (TclSourceEntry ref : moduleInfo.moduleInfo.getRequired()) {
                EList corrections = moduleInfo.moduleInfo.getPackageCorrections();
                ArrayList<TclSourceEntry> toCheck = new ArrayList<TclSourceEntry>();
                for (UserCorrection userCorrection : corrections) {
                    if (!userCorrection.getOriginalValue().equals(ref.getValue())) continue;
                    for (String correction : userCorrection.getUserValue()) {
                        TclSourceEntry to = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                        to.setEnd(ref.getEnd());
                        to.setStart(ref.getStart());
                        to.setValue(correction);
                        toCheck.add(to);
                    }
                }
                if (toCheck.isEmpty()) {
                    toCheck.add(ref);
                }
                for (TclSourceEntry tclSourceEntry : toCheck) {
                    this.checkPackage(tclSourceEntry, moduleInfo.reporter, moduleInfo.lineTracker, newDependencies, names, autoNames);
                }
            }
            this.checkSources(environment, moduleInfo);
            --remainingWork;
        }
        if (this.buildType != 10) {
            List mods = (List)this.packageCollector.getModules().get(this.project);
            ArrayList<TclModuleInfo> result = new ArrayList<TclModuleInfo>();
            for (TclModuleInfo tclModuleInfo : mods) {
                EList sourceCorrections;
                EList pkgCorrections = tclModuleInfo.getPackageCorrections();
                if (!pkgCorrections.isEmpty()) {
                    ArrayList<UserCorrection> toRemove = new ArrayList<UserCorrection>();
                    EList required = tclModuleInfo.getRequired();
                    this.processCleanCorrections((EList<UserCorrection>)pkgCorrections, toRemove, (EList<TclSourceEntry>)required);
                }
                if (!(sourceCorrections = tclModuleInfo.getSourceCorrections()).isEmpty()) {
                    ArrayList<UserCorrection> toRemove = new ArrayList<UserCorrection>();
                    EList sourced = tclModuleInfo.getSourced();
                    this.processCleanCorrections((EList<UserCorrection>)sourceCorrections, toRemove, (EList<TclSourceEntry>)sourced);
                }
                if (tclModuleInfo.getProvided().isEmpty() && tclModuleInfo.getRequired().isEmpty() && tclModuleInfo.getSourced().isEmpty() && sourceCorrections.isEmpty() && pkgCorrections.isEmpty()) continue;
                result.add(tclModuleInfo);
            }
            TclPackagesManager.setProjectModules((String)this.project.getElementName(), result);
            InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)this.project, names, newDependencies);
            try {
                ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.project}, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ModelException e) {
                DLTKCore.error((String)Messages.PackageRequireSourceAnalyser_ModelUpdateFailure, (Throwable)e);
            }
        }
    }

    private void processCleanCorrections(EList<UserCorrection> pkgCorrections, List<UserCorrection> toRemove, EList<TclSourceEntry> required) {
        for (UserCorrection userCorrection : pkgCorrections) {
            boolean found = false;
            for (TclSourceEntry tclSourceEntry : required) {
                if (!tclSourceEntry.getValue().equals(userCorrection.getOriginalValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(userCorrection);
        }
        pkgCorrections.removeAll(toRemove);
    }

    private void checkSources(IEnvironment environment, ModuleInfo moduleInfo) {
        IPath folder = moduleInfo.moduleLocation.removeLastSegments(1);
        boolean needToAddCorrection = false;
        for (TclSourceEntry source : moduleInfo.moduleInfo.getSourced()) {
            IPath sourcedPath3;
            HashSet<IPath> sourcedPaths = new HashSet<IPath>();
            EList corrections = moduleInfo.moduleInfo.getSourceCorrections();
            for (UserCorrection userCorrection : corrections) {
                if (!userCorrection.getOriginalValue().equals(source.getValue())) continue;
                IPath sourcedPath2 = null;
                EList userValues = userCorrection.getUserValue();
                for (String userValue : userValues) {
                    if (environment.isLocal()) {
                        sourcedPath2 = Path.fromOSString((String)userValue);
                    } else {
                        userValue = userValue.replace('\\', '/');
                        sourcedPath2 = Path.fromPortableString((String)userValue);
                    }
                    sourcedPaths.add(sourcedPath2);
                }
            }
            if (sourcedPaths.isEmpty() && (sourcedPath3 = this.resolveSourceValue(folder, source, environment)) != null) {
                sourcedPaths.add(sourcedPath3);
                needToAddCorrection = true;
            }
            for (IPath sourcedPath3 : sourcedPaths) {
                IFileHandle file = environment.getFile(sourcedPath3);
                if (file == null) continue;
                if (!file.exists()) {
                    this.reportSourceProblem(source, moduleInfo.reporter, NLS.bind((String)Messages.PackageRequireSourceAnalyser_CouldNotLocateSourcedFile, (Object)file.toOSString()), source.getValue(), moduleInfo.lineTracker);
                    continue;
                }
                if (file.isDirectory()) {
                    this.reportSourceProblem(source, moduleInfo.reporter, Messages.PackageRequireSourceAnalyser_FolderSourcingNotSupported, source.getValue(), moduleInfo.lineTracker);
                    continue;
                }
                if (!needToAddCorrection) continue;
                if (!this.isAutoAddPackages()) {
                    this.reportSourceProblem(source, moduleInfo.reporter, Messages.PackageRequireSourceAnalyser_SourceNotAddedToBuildpath, source.getValue(), moduleInfo.lineTracker);
                    continue;
                }
                UserCorrection correction = TclPackagesFactory.eINSTANCE.createUserCorrection();
                correction.setOriginalValue(source.getValue());
                correction.getUserValue().add((Object)file.toString());
                corrections.add((Object)correction);
            }
            if (!sourcedPaths.isEmpty() || TclPackagesManager.isValidName((String)source.getValue())) continue;
            this.reportSourceProblemCorrection(source, moduleInfo.reporter, Messages.PackageRequireSourceAnalyser_CouldNotLocateSourcedFileCorrectionRequired, source.getValue(), moduleInfo.lineTracker);
        }
    }

    private IPath resolveSourceValue(IPath folder, TclSourceEntry source, IEnvironment environment) {
        IPath valuePath;
        String value = source.getValue();
        if (environment.isLocal()) {
            valuePath = Path.fromOSString((String)value);
        } else {
            value = value.replace('\\', '/');
            valuePath = new Path(value);
        }
        if (valuePath.isAbsolute()) {
            return valuePath;
        }
        if (TclPackagesManager.isValidName((String)value)) {
            return folder.append(valuePath);
        }
        return null;
    }

    private void reportPackageProblem(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        reporter.reportProblem((IProblem)new DefaultProblem(message, 0x10000001, new String[]{pkgName}, 1, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportPackageProblemCorrection(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        reporter.reportProblem((IProblem)new DefaultProblem(message, 0x10000002, new String[]{pkgName}, 1, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportSourceProblem(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        reporter.reportProblem((IProblem)new DefaultProblem(message, 0x10000003, new String[]{pkgName}, 1, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportSourceProblemCorrection(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        reporter.reportProblem((IProblem)new DefaultProblem(message, 0x10000004, new String[]{pkgName}, 1, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void checkPackage(TclSourceEntry pkg, IProblemReporter reporter, ISourceLineTracker lineTracker, Set<String> newDependencies, Set<String> names, Set<String> autoNames) {
        String packageName = pkg.getValue();
        ArrayList<TclModuleInfo> list = new ArrayList<TclModuleInfo>();
        List collected = (List)this.packageCollector.getModules().get(this.project);
        if (collected != null) {
            list.addAll(collected);
        }
        if (this.providedByRequiredProjects != null) {
            list.addAll(this.providedByRequiredProjects);
        }
        for (TclModuleInfo tclModuleInfo : list) {
            EList provided = tclModuleInfo.getProvided();
            for (TclSourceEntry tclSourceEntry : provided) {
                IModelElement element;
                if (!tclSourceEntry.getValue().equals(packageName) || (element = DLTKCore.create((String)tclModuleInfo.getHandle())) == null || !element.exists()) continue;
                return;
            }
        }
        boolean found = false;
        for (TclPackageInfo info : this.knownInfos) {
            if (!info.getName().equals(packageName)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (!TclPackagesManager.isValidName((String)packageName)) {
                this.reportPackageProblemCorrection(pkg, reporter, NLS.bind((String)Messages.PackageRequireSourceAnalyser_CouldNotDetectPackageCorrectionRequired, (Object)packageName), packageName, lineTracker);
                return;
            }
            this.reportPackageProblem(pkg, reporter, NLS.bind((String)Messages.TclCheckBuilder_unknownPackage, (Object)packageName), packageName, lineTracker);
            return;
        }
        if (!this.isAutoAddPackages()) {
            if (!names.contains(packageName) && !autoNames.contains(packageName)) {
                this.reportPackageProblem(pkg, reporter, NLS.bind((String)Messages.TclCheckBuilder_unresolvedDependencies, (Object)packageName), packageName, lineTracker);
            }
            return;
        }
        newDependencies.add(packageName);
    }

    private final boolean isAutoAddPackages() {
        return this.autoAddPackages;
    }

    private static boolean isOnBuildpath(Set<IPath> buildpath, IPath[] paths) {
        if (paths != null) {
            IPath[] iPathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (!PackageRequireSourceAnalyser.isOnBuildpath(buildpath, path)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean isOnBuildpath(Set<IPath> buildpath, IPath path) {
        if (!buildpath.contains(path)) {
            for (IPath pp : buildpath) {
                if (!pp.isPrefixOf(path)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public IScriptBuilder.DependencyResponse getDependencies(int buildType, Set localElements, Set externalElements, Set oldExternalFolders, Set externalFolders) {
        if (buildType == 1 || !oldExternalFolders.equals(externalFolders)) {
            return IScriptBuilder.DependencyResponse.FULL_EXTERNAL_BUILD;
        }
        return null;
    }

    private static class ModuleInfo {
        final String name;
        final ISourceLineTracker lineTracker;
        final TclModuleInfo moduleInfo;
        final IProblemReporter reporter;
        final IPath moduleLocation;
        final ISourceModule sourceModule;

        public ModuleInfo(String moduleName, ISourceLineTracker codeModel, IProblemReporter reporter, TclModuleInfo moduleInfo, IPath moduleLocation, ISourceModule sourceModule) {
            this.name = moduleName;
            this.lineTracker = codeModel;
            this.reporter = reporter;
            this.moduleInfo = moduleInfo;
            this.moduleLocation = moduleLocation;
            this.sourceModule = sourceModule;
        }
    }
}

