/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.jdt.integration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.CallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.IClassReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NewReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.javascript.jdt.integration.Activator;
import org.eclipse.dltk.javascript.jdt.integration.JavaProposalReference;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtReferenceResolver
implements IReferenceResolver {
    private static final String PACKAGES = "Packages.";
    private List<String> imports = new ArrayList<String>();
    ReferenceResolverContext owner;
    IEvaluationContext context;
    IJavaProject javaProject;
    SearchEngine engine = new SearchEngine();

    public boolean canResolve(ISourceModule module) {
        IResource resource = module.getResource();
        if (resource == null) {
            return false;
        }
        IProject pr = resource.getProject();
        return JavaCore.create((IProject)pr).exists();
    }

    public Set<IReference> getChilds(IResolvableReference ref) {
        CallResultReference call;
        IReference rm;
        if (ref instanceof NewReference) {
            NewReference newRef = (NewReference)ref;
            String preId = newRef.getId();
            if (preId.startsWith(PACKAGES)) {
                preId = preId.substring(PACKAGES.length());
            }
            IJavaSearchScope javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaProject});
            SearchPattern createPattern = SearchPattern.createPattern((String)"jsFunction*", (int)1, (int)100, (int)2);
            MethodAcceptor methods = new MethodAcceptor(preId);
            try {
                this.engine.search(createPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, javaSearchScope, (SearchRequestor)methods, null);
                if (!methods.references.isEmpty()) {
                    return methods.references;
                }
            }
            catch (CoreException e) {
                Activator.error(e);
            }
            String codeSnippet = String.valueOf(preId) + " z=new " + preId + ";z.";
            try {
                CompletionAcceptor completions = new CompletionAcceptor(preId);
                this.context.codeComplete(codeSnippet, codeSnippet.length(), (CompletionRequestor)completions);
                return completions.references;
            }
            catch (JavaModelException e) {
                Activator.error(e);
            }
        } else if (ref instanceof CallResultReference && (rm = (call = (CallResultReference)ref).getRoot()) != null) {
            int lastIndexOf = call.getId().lastIndexOf(46);
            String substring = call.getId().substring(lastIndexOf + 1);
            IReference child = rm.getChild(substring, true);
            if (child == null) {
                return null;
            }
            return child.getChilds(true);
        }
        return null;
    }

    public Set<IReference> resolveGlobals(String id) {
        final HashSet<IReference> result = new HashSet<IReference>();
        if (id.startsWith(PACKAGES)) {
            id = id.substring(PACKAGES.length());
        }
        final String id2 = id;
        String sm = id;
        int indexOf = id.indexOf(46);
        if (indexOf == -1) {
            sm = "import " + sm;
            IJavaSearchScope createJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaProject});
            SearchPattern createPattern = SearchPattern.createPattern((String)"jsFunction*", (int)1, (int)100, (int)2);
            try {
                this.engine.search(createPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, createJavaSearchScope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        Object element = match.getElement();
                        if (element instanceof IMethod) {
                            IMethod m = (IMethod)element;
                            String elementName = m.getDeclaringType().getElementName();
                            ClassRef r = new ClassRef(elementName, true);
                            result.add(r);
                        }
                    }
                }, null);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            if (result.size() > 0) {
                return result;
            }
            try {
                this.context.codeComplete(sm, sm.length(), new CompletionRequestor(){

                    public void accept(CompletionProposal proposal) {
                        if (proposal.getName() != null) {
                            JavaProposalReference r = new JavaProposalReference(JdtReferenceResolver.this.context, proposal, JdtReferenceResolver.this.owner, JdtReferenceResolver.this.javaProject, "");
                            result.add(r);
                        } else {
                            char[] completion = proposal.getCompletion();
                            String sm = new String(completion);
                            JavaProposalReference r = new JavaProposalReference(JdtReferenceResolver.this.context, sm, proposal, JdtReferenceResolver.this.owner, JdtReferenceResolver.this.javaProject, "");
                            result.add(r);
                        }
                    }
                });
            }
            catch (JavaModelException javaModelException) {}
        } else {
            try {
                this.context.codeComplete(sm, sm.length(), new CompletionRequestor(){

                    public void accept(CompletionProposal proposal) {
                        if (proposal.getName() != null) {
                            JavaProposalReference r = new JavaProposalReference(JdtReferenceResolver.this.context, proposal, JdtReferenceResolver.this.owner, JdtReferenceResolver.this.javaProject, "");
                            result.add(r);
                        } else {
                            String sm;
                            char[] completion = proposal.getCompletion();
                            String pName = sm = new String(completion);
                            if (proposal.getKind() == 8) {
                                sm = sm.substring(id2.length());
                            } else if (sm.startsWith(id2) && sm.length() != id2.length()) {
                                sm = sm.substring(id2.length()).trim();
                            }
                            JavaProposalReference r = new JavaProposalReference(JdtReferenceResolver.this.context, sm, proposal, JdtReferenceResolver.this.owner, JdtReferenceResolver.this.javaProject, pName);
                            result.add(r);
                        }
                    }
                });
            }
            catch (JavaModelException javaModelException) {}
        }
        return result;
    }

    public void processCall(String call, String objId) {
        if (call.equals("importPackage")) {
            this.imports.add(objId);
        }
    }

    public void init(ReferenceResolverContext owner) {
        ISourceModule module = owner.getModule();
        IProject pr = module.getResource().getProject();
        this.javaProject = JavaCore.create((IProject)pr);
        this.context = this.javaProject.newEvaluationContext();
        String[] imps = new String[this.imports.size()];
        int a = 0;
        while (a < imps.length) {
            imps[a] = String.valueOf(this.imports.get(a).toString()) + ".*";
            ++a;
        }
        this.context.setImports(imps);
        this.owner = owner;
    }

    private static final class ClassRef
    extends StandardSelfCompletingReference
    implements IClassReference {
        private ClassRef(String paramOrVarName, boolean childIsh) {
            super(paramOrVarName, childIsh);
        }
    }

    private final class CompletionAcceptor
    extends CompletionRequestor {
        private final String cmid;
        final Set<IReference> references = new HashSet<IReference>();

        private CompletionAcceptor(String cmid) {
            this.cmid = cmid;
        }

        public void accept(CompletionProposal proposal) {
            this.references.add((IReference)new JavaProposalReference(JdtReferenceResolver.this.context, proposal, JdtReferenceResolver.this.owner, JdtReferenceResolver.this.javaProject, this.cmid));
        }
    }

    private static final class MethodAcceptor
    extends SearchRequestor {
        private final String typeId;
        final Set<IReference> references = new HashSet<IReference>();

        private MethodAcceptor(String typeId) {
            this.typeId = typeId;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (element instanceof IMethod) {
                IMethod m = (IMethod)element;
                IType declaringType = m.getDeclaringType();
                if (!declaringType.getElementName().equals(this.typeId)) {
                    return;
                }
                IMethod[] ts = declaringType.getMethods();
                int a = 0;
                while (a < ts.length) {
                    StandardSelfCompletingReference r;
                    String string = "jsFunction_";
                    String stringget = "jsGet_";
                    String stringset = "jsSet_";
                    IMethod method = ts[a];
                    if (method.getElementName().startsWith(string)) {
                        r = new StandardSelfCompletingReference(method.getElementName().substring(string.length()), true);
                        this.references.add((IReference)r);
                        r.setFunctionRef();
                    } else if (method.getElementName().startsWith(stringget)) {
                        r = new StandardSelfCompletingReference(method.getElementName().substring(stringget.length()), true);
                        this.references.add((IReference)r);
                    } else if (method.getElementName().startsWith(stringset)) {
                        r = new StandardSelfCompletingReference(method.getElementName().substring(stringset.length()), true);
                        this.references.add((IReference)r);
                    }
                    ++a;
                }
            }
        }
    }
}

